/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.CreateAttachmentException;
import microsoft.exchange.webservices.data.CreateAttachmentResponse;
import microsoft.exchange.webservices.data.DeleteAttachmentException;
import microsoft.exchange.webservices.data.DeleteAttachmentResponse;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FileAttachment;
import microsoft.exchange.webservices.data.GenericItemAttachment;
import microsoft.exchange.webservices.data.IOwnedProperty;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceResponseCollection;
import microsoft.exchange.webservices.data.ServiceResult;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public final class AttachmentCollection
extends ComplexPropertyCollection<Attachment>
implements IOwnedProperty {
    private Item owner;

    protected AttachmentCollection() {
    }

    @Override
    public ServiceObject getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(ServiceObject value) {
        Item item = (Item)value;
        EwsUtilities.EwsAssert(item != null, "AttachmentCollection.IOwnedProperty.set_Owner", "value is not a descendant of ItemBase");
        this.owner = item;
    }

    public FileAttachment addFileAttachment(String fileName) {
        return this.addFileAttachment(new File(fileName).getName(), fileName);
    }

    public FileAttachment addFileAttachment(String name, String fileName) {
        FileAttachment fileAttachment = new FileAttachment(this.owner);
        fileAttachment.setName(name);
        fileAttachment.setFileName(fileName);
        this.internalAdd(fileAttachment);
        return fileAttachment;
    }

    public FileAttachment addFileAttachment(String name, InputStream contentStream) {
        FileAttachment fileAttachment = new FileAttachment(this.owner);
        fileAttachment.setName(name);
        fileAttachment.setContentStream(contentStream);
        this.internalAdd(fileAttachment);
        return fileAttachment;
    }

    public FileAttachment addFileAttachment(String name, byte[] content) {
        FileAttachment fileAttachment = new FileAttachment(this.owner);
        fileAttachment.setName(name);
        fileAttachment.setContent(content);
        this.internalAdd(fileAttachment);
        return fileAttachment;
    }

    public <TItem extends Item> GenericItemAttachment<TItem> addItemAttachment(Class<TItem> cls) throws Exception {
        if (cls.getDeclaredFields().length == 0) {
            throw new InvalidOperationException(String.format("Items of type %s are not supported as attachments.", cls.getName()));
        }
        GenericItemAttachment<Item> itemAttachment = new GenericItemAttachment<Item>(this.owner);
        itemAttachment.setTItem(EwsUtilities.createItemFromItemClass(itemAttachment, cls, true));
        this.internalAdd(itemAttachment);
        return itemAttachment;
    }

    public void clear() {
        this.internalClear();
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException("parameter 'index' : " + Strings.IndexIsOutOfRange);
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(Attachment attachment) throws Exception {
        EwsUtilities.validateParam(attachment, "attachment");
        return this.internalRemove(attachment);
    }

    @Override
    protected Attachment createComplexProperty(String xmlElementName) {
        if (xmlElementName.equals("FileAttachment")) {
            return new FileAttachment(this.owner);
        }
        if (xmlElementName.equals("ItemAttachment")) {
            return new ItemAttachment(this.owner);
        }
        return null;
    }

    @Override
    protected String getCollectionItemXmlElementName(Attachment complexProperty) {
        if (complexProperty instanceof FileAttachment) {
            return "FileAttachment";
        }
        return "ItemAttachment";
    }

    protected void save() throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Attachment attachment : this.getRemovedItems()) {
            if (attachment.isNew()) continue;
            attachments.add(attachment);
        }
        if (attachments.size() > 0) {
            this.internalDeleteAttachments(attachments);
        }
        attachments.clear();
        for (Attachment attachment : this) {
            if (!attachment.isNew()) continue;
            attachments.add(attachment);
        }
        if (attachments.size() > 0) {
            if (this.owner.isAttachment()) {
                this.internalCreateAttachments(this.owner.getParentAttachment().getId(), attachments);
            } else {
                this.internalCreateAttachments(this.owner.getId().getUniqueId(), attachments);
            }
        }
        for (Attachment attachment : this) {
            ItemAttachment itemAttachment = (ItemAttachment)(attachment instanceof ItemAttachment ? attachment : null);
            if (itemAttachment == null || itemAttachment.getItem() == null) continue;
            itemAttachment.getItem().getAttachments().save();
            itemAttachment.getItem().clearChangeLog();
        }
        super.clearChangeLog();
    }

    protected boolean hasUnprocessedChanges() throws ServiceLocalException {
        for (Attachment attachment : this) {
            if (!attachment.isNew()) continue;
            return true;
        }
        for (Attachment attachment : this.getRemovedItems()) {
            if (attachment.isNew()) continue;
            return true;
        }
        ArrayList<ItemAttachment> itemAttachments = new ArrayList<ItemAttachment>();
        for (Object event : this.getItems()) {
            if (!(event instanceof ItemAttachment)) continue;
            itemAttachments.add((ItemAttachment)event);
        }
        for (ItemAttachment itemAttachment : itemAttachments) {
            if (itemAttachment.getItem() == null || !itemAttachment.getItem().getAttachments().hasUnprocessedChanges()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearChangeLog() {
    }

    @Override
    public void validate() throws Exception {
        boolean contactPhotoFound = false;
        for (int attachmentIndex = 0; attachmentIndex < this.getAddedItems().size(); ++attachmentIndex) {
            FileAttachment fileAttachment;
            Attachment attachment = (Attachment)this.getAddedItems().get(attachmentIndex);
            if (!attachment.isNew()) continue;
            if (this.owner.isNew() && this.owner.getService().getRequestedServerVersion().ordinal() >= ExchangeVersion.Exchange2010_SP2.ordinal() && (fileAttachment = (FileAttachment)attachment) != null && fileAttachment.isContactPhoto()) {
                if (contactPhotoFound) {
                    throw new ServiceValidationException(Strings.MultipleContactPhotosInAttachment);
                }
                contactPhotoFound = true;
            }
            attachment.validate(attachmentIndex);
        }
    }

    private void internalDeleteAttachments(Iterable<Attachment> attachments) throws Exception {
        ServiceResponseCollection<DeleteAttachmentResponse> responses = this.owner.getService().deleteAttachments(attachments);
        Enumeration<DeleteAttachmentResponse> enumerator = responses.getEnumerator();
        while (enumerator.hasMoreElements()) {
            DeleteAttachmentResponse response = enumerator.nextElement();
            if (response.getResult() == ServiceResult.Error) continue;
            this.removeFromChangeLog(response.getAttachment());
        }
        if (responses.getOverallResult() == ServiceResult.Error) {
            throw new DeleteAttachmentException(responses, Strings.AtLeastOneAttachmentCouldNotBeDeleted);
        }
    }

    private void internalCreateAttachments(String parentItemId, Iterable<Attachment> attachments) throws Exception {
        ServiceResponseCollection<CreateAttachmentResponse> responses = this.owner.getService().createAttachments(parentItemId, attachments);
        Enumeration<CreateAttachmentResponse> enumerator = responses.getEnumerator();
        while (enumerator.hasMoreElements()) {
            CreateAttachmentResponse response = enumerator.nextElement();
            if (response.getResult() == ServiceResult.Error) continue;
            this.removeFromChangeLog(response.getAttachment());
        }
        if (responses.getOverallResult() == ServiceResult.Error) {
            throw new CreateAttachmentException(responses, Strings.AttachmentCreationFailed);
        }
    }
}

