/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GenericPropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.TaskDelegationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TaskDelegationStatePropertyDefinition
extends GenericPropertyDefinition<TaskDelegationState> {
    private static final String NoMatch = "NoMatch";
    private static final String OwnNew = "OwnNew";
    private static final String Owned = "Owned";
    private static final String Accepted = "Accepted";

    protected TaskDelegationStatePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(TaskDelegationState.class, xmlElementName, uri, flags, version);
    }

    @Override
    protected Object parse(String value) {
        switch (Status.valueOf(value)) {
            case NoMatch: {
                return TaskDelegationState.NoDelegation;
            }
            case OwnNew: {
                return TaskDelegationState.Unknown;
            }
            case Owned: {
                return TaskDelegationState.Accepted;
            }
            case Accepted: {
                return TaskDelegationState.Declined;
            }
        }
        EwsUtilities.EwsAssert(false, "TaskDelegationStatePropertyDefinition.Parse", String.format("TaskDelegationStatePropertyDefinition.Parse(): value %s cannot be handled.", value));
        return null;
    }

    @Override
    protected String toString(Object value) {
        TaskDelegationState taskDelegationState = (TaskDelegationState)((Object)value);
        if (taskDelegationState.equals((Object)TaskDelegationState.NoDelegation)) {
            return NoMatch;
        }
        if (taskDelegationState.equals((Object)TaskDelegationState.Unknown)) {
            return OwnNew;
        }
        if (taskDelegationState.equals((Object)TaskDelegationState.Accepted)) {
            return Owned;
        }
        if (taskDelegationState.equals((Object)TaskDelegationState.Declined)) {
            return Accepted;
        }
        EwsUtilities.EwsAssert(false, "TaskDelegationStatePropertyDefinition.ToString", "Invalid TaskDelegationState value.");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NoMatch,
        OwnNew,
        Owned,
        Accepted;

    }
}

