/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class DomainSettingError {
    private AutodiscoverErrorCode errorCode;
    private String errorMessage;
    private String settingName;

    DomainSettingError() {
    }

    void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("ErrorCode")) {
                this.errorCode = reader.readElementValue(AutodiscoverErrorCode.class);
                continue;
            }
            if (reader.getLocalName().equals("ErrorMessage")) {
                this.errorMessage = reader.readElementValue();
                continue;
            }
            if (!reader.getLocalName().equals("SettingName")) continue;
            this.settingName = reader.readElementValue();
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "DomainSettingError"));
    }

    public AutodiscoverErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSettingName() {
        return this.settingName;
    }
}

