/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.NotificationEvent;

public final class ItemEvent
extends NotificationEvent {
    private ItemId itemId;
    private ItemId oldItemId;

    protected ItemEvent(EventType eventType, Date timestamp) {
        super(eventType, timestamp);
    }

    protected void internalLoadFromXml(EwsServiceXmlReader reader) throws Exception {
        super.internalLoadFromXml(reader);
        this.itemId = new ItemId();
        this.itemId.loadFromXml(reader, reader.getLocalName());
        reader.read();
        this.setParentFolderId(new FolderId());
        this.getParentFolderId().loadFromXml(reader, "ParentFolderId");
        EventType eventType = this.getEventType();
        switch (eventType) {
            case Moved: 
            case Copied: {
                reader.read();
                this.oldItemId = new ItemId();
                this.oldItemId.loadFromXml(reader, reader.getLocalName());
                reader.read();
                this.setOldParentFolderId(new FolderId());
                this.getOldParentFolderId().loadFromXml(reader, reader.getLocalName());
                break;
            }
        }
    }

    public ItemId getItemId() {
        return this.itemId;
    }

    public ItemId getOldItemId() {
        return this.oldItemId;
    }
}

