/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FormatException;
import microsoft.exchange.webservices.data.IFunction;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapiTypeConverterMapEntry {
    private static LazyMember<Map<Class, Object>> defaultValueMap = new LazyMember<Map<Class, Object>>(new ILazyMember<Map<Class, Object>>(){

        @Override
        public Map<Class, Object> createInstance() {
            HashMap<Class, Object> map = new HashMap<Class, Object>();
            map.put(Boolean.class, false);
            map.put(Byte[].class, null);
            map.put(Short.class, new Short(0));
            map.put(Integer.class, 0);
            map.put(Long.class, new Long(0L));
            map.put(Float.class, new Float(0.0));
            map.put(Double.class, new Double(0.0));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                map.put(Date.class, formatter.parse("0001-01-01 12:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            map.put(UUID.class, UUID.fromString("00000000-0000-0000-0000-000000000000"));
            map.put(String.class, null);
            return map;
        }
    });
    boolean isArray;
    Class type;
    IFunction<Object, String> convertToString;
    IFunction<String, Object> parse;

    protected MapiTypeConverterMapEntry(Class type) {
        EwsUtilities.EwsAssert(defaultValueMap.getMember().containsKey(type), "MapiTypeConverterMapEntry ctor", String.format("No default value entry for type {0}", type.getName()));
        this.type = type;
        this.convertToString = new IFunction<Object, String>(){

            @Override
            public String func(Object o) {
                return String.valueOf(o);
            }
        };
        this.parse = new IFunction<String, Object>(){

            @Override
            public Object func(String o) {
                return o;
            }
        };
    }

    protected Object changeType(Object value) throws Exception {
        if (this.getIsArray()) {
            this.validateValueAsArray(value);
            return value;
        }
        if (value.getClass() == this.getType()) {
            return value;
        }
        try {
            if (this.getType().isInstance(0)) {
                Integer o = null;
                o = Integer.parseInt(value + "");
                return o;
            }
            if (this.getType().isInstance(new Date())) {
                Object o = null;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return df.parse(value + "");
            }
            if (this.getType().isInstance(false)) {
                Boolean o = null;
                o = Boolean.parseBoolean(value + "");
                return o;
            }
            if (this.getType().isInstance(String.class)) {
                return value;
            }
            return null;
        }
        catch (ClassCastException ex) {
            throw new ArgumentException(String.format(Strings.ValueOfTypeCannotBeConverted, "%s", "%s", this.getType()), ex);
        }
    }

    protected Object convertToValue(String stringValue) throws ServiceXmlDeserializationException, FormatException {
        try {
            return this.getParse().func(stringValue);
        }
        catch (ClassCastException ex) {
            throw new ServiceXmlDeserializationException(String.format(Strings.ValueCannotBeConverted, stringValue, this.getType()), ex);
        }
        catch (NumberFormatException ex) {
            throw new ServiceXmlDeserializationException(String.format(Strings.ValueCannotBeConverted, stringValue, this.getType()), ex);
        }
    }

    protected Object ConvertToValueOrDefault(String stringValue) throws ServiceXmlDeserializationException, FormatException {
        return stringValue == null || stringValue.isEmpty() ? this.getDefaultValue() : this.convertToValue(stringValue);
    }

    private void validateValueAsArray(Object value) throws ArgumentException {
        Array array = null;
        if (value instanceof Array) {
            array = (Array)value;
        }
        if (array == null) {
            throw new ArgumentException(String.format(Strings.IncompatibleTypeForArray, value.getClass(), this.getType()));
        }
        if (MapiTypeConverterMapEntry.getDim(array) != 1) {
            throw new ArgumentException(Strings.ArrayMustHaveSingleDimension);
        }
        if (Array.getLength(array) == 0) {
            throw new ArgumentException(Strings.ArrayMustHaveAtLeastOneElement);
        }
        if (array.getClass().getComponentType() != this.getType()) {
            throw new ArgumentException(String.format(Strings.IncompatibleTypeForArray, value.getClass(), this.getType()));
        }
    }

    public static int getDim(Object array) {
        int dim = 0;
        Class<?> cls = array.getClass();
        while (cls.isArray()) {
            ++dim;
            cls = cls.getComponentType();
        }
        return dim;
    }

    protected Class getType() {
        return this.type;
    }

    protected void setType(Class cls) {
        this.type = cls;
    }

    protected boolean getIsArray() {
        return this.isArray;
    }

    protected void setIsArray(boolean value) {
        this.isArray = value;
    }

    protected IFunction<Object, String> getConvertToString() {
        return this.convertToString;
    }

    protected void setConvertToString(IFunction<Object, String> value) {
        this.convertToString = value;
    }

    protected IFunction<String, Object> getParse() {
        return this.parse;
    }

    protected void setParse(IFunction<String, Object> value) {
        this.parse = value;
    }

    protected Object getDefaultValue() {
        return defaultValueMap.getMember().get(this.type);
    }
}

