/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.DayOfTheWeekCollection;
import microsoft.exchange.webservices.data.DayOfTheWeekIndex;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EndDateRecurrenceRange;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.Month;
import microsoft.exchange.webservices.data.NoEndRecurrenceRange;
import microsoft.exchange.webservices.data.NumberedRecurrenceRange;
import microsoft.exchange.webservices.data.RecurrenceRange;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Recurrence
extends ComplexProperty {
    private Date startDate;
    private Integer numberOfOccurrences;
    private Date endDate;

    protected Recurrence() {
    }

    protected Recurrence(Date startDate) {
        this();
        this.startDate = startDate;
    }

    protected abstract String getXmlElementName();

    protected boolean isRegenerationPattern() {
        return false;
    }

    protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException, ServiceValidationException, Exception {
    }

    @Override
    protected final void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getXmlElementName());
        this.internalWritePropertiesToXml(writer);
        writer.writeEndElement();
        RecurrenceRange range = null;
        if (!this.hasEnd()) {
            range = new NoEndRecurrenceRange(this.getStartDate());
        } else if (this.getNumberOfOccurrences() != null) {
            range = new NumberedRecurrenceRange(this.startDate, this.numberOfOccurrences);
        } else if (this.getEndDate() != null) {
            range = new EndDateRecurrenceRange(this.getStartDate(), this.getEndDate());
        }
        if (range != null) {
            range.writeToXml(writer, range.getXmlElementName());
        }
    }

    protected <T> T getFieldValueOrThrowIfNull(Class<T> cls, Object value, String name) throws ServiceValidationException {
        if (value != null) {
            return (T)value;
        }
        throw new ServiceValidationException(String.format(Strings.PropertyValueMustBeSpecifiedForRecurrencePattern, name));
    }

    public Date getStartDate() throws ServiceValidationException {
        return this.getFieldValueOrThrowIfNull(Date.class, this.startDate, "StartDate");
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public boolean hasEnd() {
        return this.numberOfOccurrences != null || this.endDate != null;
    }

    public void neverEnds() {
        this.numberOfOccurrences = null;
        this.endDate = null;
        this.changed();
    }

    @Override
    protected void internalValidate() throws Exception {
        super.internalValidate();
        if (this.startDate == null) {
            throw new ServiceValidationException(Strings.RecurrencePatternMustHaveStartDate);
        }
    }

    public Integer getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setNumberOfOccurrences(Integer value) throws ArgumentException {
        if (value < 1) {
            throw new ArgumentException(Strings.NumberOfOccurrencesMustBeGreaterThanZero);
        }
        if (this.canSetFieldValue(this.numberOfOccurrences, value)) {
            this.numberOfOccurrences = value;
            this.changed();
        }
        this.endDate = null;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        if (this.canSetFieldValue(this.endDate, value)) {
            this.endDate = value;
            this.changed();
        }
        this.numberOfOccurrences = null;
    }

    public static final class YearlyRegenerationPattern
    extends IntervalPattern {
        protected String getXmlElementName() {
            return "YearlyRegeneration";
        }

        protected boolean isRegenerationPattern() {
            return true;
        }

        public YearlyRegenerationPattern() {
        }

        public YearlyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }
    }

    public static final class YearlyPattern
    extends Recurrence {
        private Month month;
        private Integer dayOfMonth;

        public YearlyPattern() {
        }

        public YearlyPattern(Date startDate, Month month, int dayOfMonth) {
            super(startDate);
            this.month = month;
            this.dayOfMonth = dayOfMonth;
        }

        protected String getXmlElementName() {
            return "AbsoluteYearlyRecurrence";
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DayOfMonth", this.getDayOfMonth());
            writer.writeElementValue(XmlNamespace.Types, "Month", (Object)this.getMonth());
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DayOfMonth")) {
                this.dayOfMonth = reader.readElementValue(Integer.TYPE);
                return true;
            }
            if (reader.getLocalName().equals("Month")) {
                this.month = reader.readElementValue(Month.class);
                return true;
            }
            return false;
        }

        protected void internalValidate() throws Exception {
            super.internalValidate();
            if (this.month == null) {
                throw new ServiceValidationException(Strings.MonthMustBeSpecifiedForRecurrencePattern);
            }
            if (this.dayOfMonth == null) {
                throw new ServiceValidationException(Strings.DayOfMonthMustBeSpecifiedForRecurrencePattern);
            }
        }

        public Month getMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Month.class, (Object)this.month, "Month");
        }

        public void setMonth(Month value) {
            if (this.canSetFieldValue(this.month, value)) {
                this.month = value;
                this.changed();
            }
        }

        public int getDayOfMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Integer.TYPE, this.dayOfMonth, "DayOfMonth");
        }

        public void setDayOfMonth(int value) throws ArgumentOutOfRangeException {
            if (value < 1 || value > 31) {
                throw new ArgumentOutOfRangeException("DayOfMonth", Strings.DayOfMonthMustBeBetween1And31);
            }
            if (this.canSetFieldValue(this.dayOfMonth, value)) {
                this.dayOfMonth = value;
                this.changed();
            }
        }
    }

    public static final class WeeklyRegenerationPattern
    extends IntervalPattern {
        public WeeklyRegenerationPattern() {
        }

        public WeeklyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        protected String getXmlElementName() {
            return "WeeklyRegeneration";
        }

        protected boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class WeeklyPattern
    extends IntervalPattern
    implements IComplexPropertyChangedDelegate {
        private DayOfTheWeekCollection daysOfTheWeek = new DayOfTheWeekCollection();
        private Calendar firstDayOfWeek;

        public WeeklyPattern() {
            this.daysOfTheWeek.addOnChangeEvent(this);
        }

        public WeeklyPattern(Date startDate, int interval, DayOfTheWeek ... daysOfTheWeek) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            ArrayList<DayOfTheWeek> toProcess = new ArrayList<DayOfTheWeek>(Arrays.asList(daysOfTheWeek));
            Iterator<DayOfTheWeek> idaysOfTheWeek = toProcess.iterator();
            this.daysOfTheWeek.addRange(idaysOfTheWeek);
        }

        private void daysOfTheWeekChanged(ComplexProperty complexProperty) {
            this.changed();
        }

        protected String getXmlElementName() {
            return "WeeklyRecurrence";
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            this.getDaysOfTheWeek().writeToXml(writer, "DaysOfWeek");
            if (this.firstDayOfWeek != null) {
                EwsUtilities.validatePropertyVersion((ExchangeService)writer.getService(), ExchangeVersion.Exchange2010_SP1, "FirstDayOfWeek");
                writer.writeElementValue(XmlNamespace.Types, "FirstDayOfWeek", this.firstDayOfWeek);
            }
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.getDaysOfTheWeek().loadFromXml(reader, reader.getLocalName());
                return true;
            }
            if (reader.getLocalName().equals("FirstDayOfWeek")) {
                this.firstDayOfWeek = reader.readElementValue(Calendar.class, XmlNamespace.Types, "FirstDayOfWeek");
                return true;
            }
            return false;
        }

        protected void internalValidate() throws Exception {
            super.internalValidate();
            if (this.getDaysOfTheWeek().getCount() == 0) {
                throw new ServiceValidationException(Strings.DaysOfTheWeekNotSpecified);
            }
        }

        public DayOfTheWeekCollection getDaysOfTheWeek() {
            return this.daysOfTheWeek;
        }

        public Calendar getFirstDayOfWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Calendar.class, this.firstDayOfWeek, "FirstDayOfWeek");
        }

        public void setFirstDayOfWeek(Calendar value) {
            if (this.canSetFieldValue(this.firstDayOfWeek, value)) {
                this.firstDayOfWeek = value;
                this.changed();
            }
        }

        public void complexPropertyChanged(ComplexProperty complexProperty) {
            this.daysOfTheWeekChanged(complexProperty);
        }
    }

    public static final class RelativeYearlyPattern
    extends Recurrence {
        private DayOfTheWeek dayOfTheWeek;
        private DayOfTheWeekIndex dayOfTheWeekIndex;
        private Month month;

        protected String getXmlElementName() {
            return "RelativeYearlyRecurrence";
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", (Object)this.dayOfTheWeek);
            writer.writeElementValue(XmlNamespace.Types, "DayOfWeekIndex", (Object)this.dayOfTheWeekIndex);
            writer.writeElementValue(XmlNamespace.Types, "Month", (Object)this.month);
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
                return true;
            }
            if (reader.getLocalName().equals("DayOfWeekIndex")) {
                this.dayOfTheWeekIndex = reader.readElementValue(DayOfTheWeekIndex.class);
                return true;
            }
            if (reader.getLocalName().equals("Month")) {
                this.month = reader.readElementValue(Month.class);
                return true;
            }
            return false;
        }

        public RelativeYearlyPattern() {
        }

        public RelativeYearlyPattern(Date startDate, Month month, DayOfTheWeek dayOfTheWeek, DayOfTheWeekIndex dayOfTheWeekIndex) {
            super(startDate);
            this.month = month;
            this.dayOfTheWeek = dayOfTheWeek;
            this.dayOfTheWeekIndex = dayOfTheWeekIndex;
        }

        protected void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfTheWeekIndex == null) {
                throw new ServiceValidationException(Strings.DayOfWeekIndexMustBeSpecifiedForRecurrencePattern);
            }
            if (this.dayOfTheWeek == null) {
                throw new ServiceValidationException(Strings.DayOfTheWeekMustBeSpecifiedForRecurrencePattern);
            }
            if (this.month == null) {
                throw new ServiceValidationException(Strings.MonthMustBeSpecifiedForRecurrencePattern);
            }
        }

        public DayOfTheWeekIndex getDayOfTheWeekIndex() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeekIndex.class, (Object)this.dayOfTheWeekIndex, "DayOfTheWeekIndex");
        }

        public void setDayOfTheWeekIndex(DayOfTheWeekIndex value) {
            if (this.canSetFieldValue(this.dayOfTheWeekIndex, value)) {
                this.dayOfTheWeekIndex = value;
                this.changed();
            }
        }

        public DayOfTheWeek getDayOfTheWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeek.class, (Object)this.dayOfTheWeek, "DayOfTheWeek");
        }

        public void setDayOfTheWeek(DayOfTheWeek value) {
            if (this.canSetFieldValue(this.dayOfTheWeek, value)) {
                this.dayOfTheWeek = value;
                this.changed();
            }
        }

        public Month getMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Month.class, (Object)this.month, "Month");
        }

        public void setMonth(Month value) {
            if (this.canSetFieldValue(this.month, value)) {
                this.month = value;
                this.changed();
            }
        }
    }

    public static final class RelativeMonthlyPattern
    extends IntervalPattern {
        private DayOfTheWeek dayOfTheWeek;
        private DayOfTheWeekIndex dayOfTheWeekIndex;

        public RelativeMonthlyPattern() {
        }

        public RelativeMonthlyPattern(Date startDate, int interval, DayOfTheWeek dayOfTheWeek, DayOfTheWeekIndex dayOfTheWeekIndex) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            this.setDayOfTheWeek(dayOfTheWeek);
            this.setDayOfTheWeekIndex(dayOfTheWeekIndex);
        }

        protected String getXmlElementName() {
            return "RelativeMonthlyRecurrence";
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", (Object)this.getDayOfTheWeek());
            writer.writeElementValue(XmlNamespace.Types, "DayOfWeekIndex", (Object)this.getDayOfTheWeekIndex());
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
                return true;
            }
            if (reader.getLocalName().equals("DayOfWeekIndex")) {
                this.dayOfTheWeekIndex = reader.readElementValue(DayOfTheWeekIndex.class);
                return true;
            }
            return false;
        }

        protected void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfTheWeek == null) {
                throw new ServiceValidationException(Strings.DayOfTheWeekMustBeSpecifiedForRecurrencePattern);
            }
            if (this.dayOfTheWeekIndex == null) {
                throw new ServiceValidationException(Strings.DayOfWeekIndexMustBeSpecifiedForRecurrencePattern);
            }
        }

        public DayOfTheWeekIndex getDayOfTheWeekIndex() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeekIndex.class, (Object)this.dayOfTheWeekIndex, "DayOfTheWeekIndex");
        }

        public void setDayOfTheWeekIndex(DayOfTheWeekIndex value) {
            if (this.canSetFieldValue(this.dayOfTheWeekIndex, value)) {
                this.dayOfTheWeekIndex = value;
                this.changed();
            }
        }

        public DayOfTheWeek getDayOfTheWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeek.class, (Object)this.dayOfTheWeek, "DayOfTheWeek");
        }

        public void setDayOfTheWeek(DayOfTheWeek value) {
            if (this.canSetFieldValue(this.dayOfTheWeek, value)) {
                this.dayOfTheWeek = value;
                this.changed();
            }
        }
    }

    public static final class MonthlyRegenerationPattern
    extends IntervalPattern {
        public MonthlyRegenerationPattern() {
        }

        public MonthlyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        protected String getXmlElementName() {
            return "MonthlyRegeneration";
        }

        protected boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class MonthlyPattern
    extends IntervalPattern {
        private Integer dayOfMonth;

        public MonthlyPattern() {
        }

        public MonthlyPattern(Date startDate, int interval, int dayOfMonth) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            this.setDayOfMonth(dayOfMonth);
        }

        protected String getXmlElementName() {
            return "AbsoluteMonthlyRecurrence";
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DayOfMonth", this.getDayOfMonth());
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DayOfMonth")) {
                this.dayOfMonth = reader.readElementValue(Integer.TYPE);
                return true;
            }
            return false;
        }

        protected void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfMonth == null) {
                throw new ServiceValidationException(Strings.DayOfMonthMustBeBetween1And31);
            }
        }

        public int getDayOfMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Integer.TYPE, this.dayOfMonth, "DayOfMonth");
        }

        public void setDayOfMonth(int value) throws ArgumentOutOfRangeException {
            if (value < 1 || value > 31) {
                throw new ArgumentOutOfRangeException("DayOfMonth", Strings.DayOfMonthMustBeBetween1And31);
            }
            if (this.canSetFieldValue(this.dayOfMonth, value)) {
                this.dayOfMonth = value;
                this.changed();
            }
        }
    }

    @EditorBrowsable(state=EditorBrowsableState.Never)
    public static abstract class IntervalPattern
    extends Recurrence {
        private int interval = 1;

        protected IntervalPattern() {
        }

        protected IntervalPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate);
            if (interval < 1) {
                throw new ArgumentOutOfRangeException("interval", Strings.IntervalMustBeGreaterOrEqualToOne);
            }
            this.setInterval(interval);
        }

        protected void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException, ServiceValidationException, Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "Interval", this.getInterval());
        }

        protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("Interval")) {
                this.interval = reader.readElementValue(Integer.class);
                return true;
            }
            return false;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int value) throws ArgumentOutOfRangeException {
            if (value < 1) {
                throw new ArgumentOutOfRangeException("value", Strings.IntervalMustBeGreaterOrEqualToOne);
            }
            if (this.canSetFieldValue(this.interval, value)) {
                this.interval = value;
                this.changed();
            }
        }
    }

    public static final class DailyRegenerationPattern
    extends IntervalPattern {
        public DailyRegenerationPattern() {
        }

        public DailyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        protected String getXmlElementName() {
            return "DailyRegeneration";
        }

        protected boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class DailyPattern
    extends IntervalPattern {
        protected String getXmlElementName() {
            return "DailyRecurrence";
        }

        public DailyPattern() {
        }

        public DailyPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }
    }
}

