/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.ConversationAction;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApplyConversationActionRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private List<ConversationAction> conversationActions = new ArrayList<ConversationAction>();

    public List<ConversationAction> getConversationActions() {
        return this.conversationActions;
    }

    protected ApplyConversationActionRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.conversationActions.size();
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.conversationActions.iterator(), "conversationActions");
        for (int iAction = 0; iAction < this.getConversationActions().size(); ++iAction) {
            this.getConversationActions().get(iAction).validate();
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ConversationActions");
        for (int iAction = 0; iAction < this.getConversationActions().size(); ++iAction) {
            this.getConversationActions().get(iAction).writeElementsToXml(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected String getXmlElementName() {
        return "ApplyConversationAction";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ApplyConversationActionResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ApplyConversationActionResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }
}

