/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.IAsyncResult;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResponseCollection;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.ServiceResult;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MultiResponseServiceRequest<TResponse extends ServiceResponse>
extends SimpleServiceRequestBase {
    private ServiceErrorHandling errorHandlingMode;

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        ServiceResponseCollection<TResponse> serviceResponses = new ServiceResponseCollection<TResponse>();
        reader.readStartElement(XmlNamespace.Messages, "ResponseMessages");
        for (int i = 0; i < this.getExpectedResponseMessageCount(); ++i) {
            reader.read();
            if (reader.isEndElement(XmlNamespace.Messages, "ResponseMessages")) break;
            TResponse response = this.createServiceResponse(reader.getService(), i);
            ((ServiceResponse)response).loadFromXml(reader, this.getResponseMessageXmlElementName());
            serviceResponses.add(response);
        }
        if (serviceResponses.getCount() < this.getExpectedResponseMessageCount()) {
            if (serviceResponses.getCount() == 1 && ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).getResult() == ServiceResult.Error) {
                throw new ServiceResponseException((ServiceResponse)serviceResponses.getResponseAtIndex(0));
            }
            throw new ServiceXmlDeserializationException(String.format(Strings.TooFewServiceReponsesReturned, this.getResponseMessageXmlElementName(), this.getExpectedResponseMessageCount(), serviceResponses.getCount()));
        }
        reader.readEndElementIfNecessary(XmlNamespace.Messages, "ResponseMessages");
        return serviceResponses;
    }

    protected abstract TResponse createServiceResponse(ExchangeService var1, int var2) throws Exception;

    protected abstract String getResponseMessageXmlElementName();

    protected abstract int getExpectedResponseMessageCount();

    protected MultiResponseServiceRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service);
        this.errorHandlingMode = errorHandlingMode;
    }

    protected ServiceResponseCollection<TResponse> execute() throws Exception {
        ServiceResponseCollection serviceResponses = (ServiceResponseCollection)this.internalExecute();
        if (this.errorHandlingMode == ServiceErrorHandling.ThrowOnError) {
            EwsUtilities.EwsAssert(serviceResponses.getCount() == 1, "MultiResponseServiceRequest.Execute", "ServiceErrorHandling.ThrowOnError error handling is only valid for singleton request");
            ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).throwIfNecessary();
        }
        return serviceResponses;
    }

    protected ServiceResponseCollection<TResponse> endExecute(IAsyncResult asyncResult) throws Exception {
        ServiceResponseCollection serviceResponses = (ServiceResponseCollection)this.endInternalExecute(asyncResult);
        if (this.errorHandlingMode == ServiceErrorHandling.ThrowOnError) {
            EwsUtilities.EwsAssert(serviceResponses.getCount() == 1, "MultiResponseServiceRequest.Execute", "ServiceErrorHandling.ThrowOnError error handling is only valid for singleton request");
            ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).throwIfNecessary();
        }
        return serviceResponses;
    }

    protected ServiceErrorHandling getErrorHandlingMode() {
        return this.errorHandlingMode;
    }
}

