/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.extension.exchange.listener.IntegrationListener;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class ExchangeLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(ExchangeLoginListener.class);
    private IntegrationListener exchangeListenerService;

    public IntegrationListener getExchangeListenerService() {
        if (this.exchangeListenerService == null) {
            try {
                this.exchangeListenerService = (IntegrationListener)PortalContainer.getInstance().getComponentInstanceOfType(IntegrationListener.class);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return this.exchangeListenerService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String username = ((ConversationState)event.getData()).getIdentity().getUserId();
        if (StringUtils.isNotEmpty((String)username) && !username.equals(IdentityConstants.ANONIM)) {
            this.getExchangeListenerService().userLoggedIn(username, null);
        }
    }
}

