/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.exception.service.remote;

import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRemoteException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;

public class ServiceResponseException
extends ServiceRemoteException {
    private static final long serialVersionUID = 1L;
    private static final String ExceptionClassKey = "ExceptionClass";
    private static final String ExceptionMessageKey = "ExceptionMessage";
    private static final String StackTraceKey = "StackTrace";
    private ServiceResponse response;

    public ServiceResponseException(ServiceResponse response) {
        this.response = response;
    }

    public ServiceResponse getResponse() {
        return this.response;
    }

    public ServiceError getErrorCode() {
        return this.response.getErrorCode();
    }

    public String getMessage() {
        if (this.response.getErrorCode() == ServiceError.ErrorInternalServerError && this.response.getErrorDetails().containsKey(ExceptionClassKey) && this.response.getErrorDetails().containsKey(ExceptionMessageKey) && this.response.getErrorDetails().containsKey(StackTraceKey)) {
            String exceptionClass = this.response.getErrorDetails().get(ExceptionClassKey);
            String exceptionMessage = this.response.getErrorDetails().get(ExceptionMessageKey);
            String stackTrace = this.response.getErrorDetails().get(StackTraceKey);
            return String.format("%s -- Server Error: %s: %s %s", this.response.getErrorMessage(), exceptionClass, exceptionMessage, stackTrace);
        }
        return this.response.getErrorMessage();
    }
}

