/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.core.request.DelegateManagementRequestBase;
import microsoft.exchange.webservices.data.core.response.DelegateManagementResponse;
import microsoft.exchange.webservices.data.property.complex.DelegateUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDelegateRequest
extends DelegateManagementRequestBase<DelegateManagementResponse> {
    private List<DelegateUser> delegateUsers = new ArrayList<DelegateUser>();
    private MeetingRequestsDeliveryScope meetingRequestsDeliveryScope;

    public UpdateDelegateRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getDelegateUsers().iterator(), "DelegateUsers");
        for (DelegateUser delegateUser : this.getDelegateUsers()) {
            delegateUser.validateUpdateDelegate();
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        writer.writeStartElement(XmlNamespace.Messages, "DelegateUsers");
        for (DelegateUser delegateUser : this.getDelegateUsers()) {
            delegateUser.writeToXml(writer, "DelegateUser");
        }
        writer.writeEndElement();
        if (this.getMeetingRequestsDeliveryScope() != null) {
            writer.writeElementValue(XmlNamespace.Messages, "DeliverMeetingRequests", (Object)this.getMeetingRequestsDeliveryScope());
        }
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateDelegateResponse";
    }

    @Override
    protected DelegateManagementResponse createResponse() {
        return new DelegateManagementResponse(true, this.delegateUsers);
    }

    @Override
    public String getXmlElementName() {
        return "UpdateDelegate";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public MeetingRequestsDeliveryScope getMeetingRequestsDeliveryScope() {
        return this.meetingRequestsDeliveryScope;
    }

    public void setMeetingRequestsDeliveryScope(MeetingRequestsDeliveryScope value) {
        this.meetingRequestsDeliveryScope = value;
    }

    public List<DelegateUser> getDelegateUsers() {
        return this.delegateUsers;
    }
}

