/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.Date;
import java.util.UUID;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.misc.IFunction;
import org.apache.commons.codec.binary.Base64;

public final class IFunctions {
    private IFunctions() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateTimeToXSDateTime
    implements IFunction<Object, String> {
        public static final DateTimeToXSDateTime INSTANCE = new DateTimeToXSDateTime();

        @Override
        public String func(Object o) {
            return EwsUtilities.dateTimeToXSDateTime((Date)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToLowerCase
    implements IFunction<Object, String> {
        public static final ToLowerCase INSTANCE = new ToLowerCase();

        @Override
        public String func(Object o) {
            return o == null ? null : o.toString().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Base64Encoder
    implements IFunction<Object, String> {
        public static final Base64Encoder INSTANCE = new Base64Encoder();

        @Override
        public String func(Object o) {
            return Base64.encodeBase64String((byte[])((byte[])o));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Base64Decoder
    implements IFunction<String, Object> {
        public static final Base64Decoder INSTANCE = new Base64Decoder();

        @Override
        public Object func(String s) {
            return Base64.decodeBase64((String)s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToUUID
    implements IFunction<String, Object> {
        public static final ToUUID INSTANCE = new ToUUID();

        @Override
        public Object func(String s) {
            return UUID.fromString(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringToObject
    implements IFunction<String, Object> {
        public static final StringToObject INSTANCE = new StringToObject();

        @Override
        public Object func(String o) {
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToBoolean
    implements IFunction<String, Object> {
        public static final ToBoolean INSTANCE = new ToBoolean();

        @Override
        public Boolean func(String s) {
            return Boolean.parseBoolean(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToString
    implements IFunction<Object, String> {
        public static final ToString INSTANCE = new ToString();

        @Override
        public String func(Object o) {
            return String.valueOf(o);
        }
    }
}

