/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.ExtendedProperty;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public final class ExtendedPropertyCollection
extends ComplexPropertyCollection<ExtendedProperty>
implements ICustomXmlUpdateSerializer {
    @Override
    protected ExtendedProperty createComplexProperty(String xmlElementName) {
        return null;
    }

    @Override
    protected String getCollectionItemXmlElementName(ExtendedProperty complexProperty) {
        return null;
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        ExtendedProperty extendedProperty = new ExtendedProperty();
        extendedProperty.loadFromXml(reader, reader.getLocalName());
        this.internalAdd(extendedProperty);
    }

    @Override
    public void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws Exception {
        for (ExtendedProperty extendedProperty : this) {
            extendedProperty.writeToXml(writer, "ExtendedProperty");
        }
    }

    private ExtendedProperty getOrAddExtendedProperty(ExtendedPropertyDefinition propertyDefinition) throws Exception {
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (!this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = new ExtendedProperty(propertyDefinition);
            this.internalAdd(extendedProperty);
        } else {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
        }
        return extendedProperty;
    }

    public void setExtendedProperty(ExtendedPropertyDefinition propertyDefinition, Object value) throws Exception {
        ExtendedProperty extendedProperty = this.getOrAddExtendedProperty(propertyDefinition);
        extendedProperty.setValue(value);
    }

    public boolean removeExtendedProperty(ExtendedPropertyDefinition propertyDefinition) throws Exception {
        EwsUtilities.validateParam(propertyDefinition, "propertyDefinition");
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
            return this.internalRemove(extendedProperty);
        }
        return false;
    }

    private boolean tryGetProperty(ExtendedPropertyDefinition propertyDefinition, OutParam<ExtendedProperty> extendedPropertyOut) {
        boolean found = false;
        extendedPropertyOut.setParam((Object)null);
        for (ExtendedProperty prop : this.getItems()) {
            if (!prop.getPropertyDefinition().equals(propertyDefinition)) continue;
            found = true;
            extendedPropertyOut.setParam((Object)prop);
            break;
        }
        return found;
    }

    public <T> boolean tryGetValue(Class<T> cls, ExtendedPropertyDefinition propertyDefinition, OutParam<T> propertyValueOut) throws ArgumentException {
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
            if (!cls.isAssignableFrom(propertyDefinition.getType())) {
                String errorMessage = String.format("Property definition type '%s' and type parameter '%s' aren't compatible.", propertyDefinition.getType().getSimpleName(), cls.getSimpleName());
                throw new ArgumentException(errorMessage, "propertyDefinition");
            }
            propertyValueOut.setParam(extendedProperty.getValue());
            return true;
        }
        propertyValueOut.setParam((Object)null);
        return false;
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, PropertyDefinition propertyDefinition) throws Exception {
        ArrayList propertiesToSet = new ArrayList();
        propertiesToSet.addAll(this.getAddedItems());
        propertiesToSet.addAll(this.getModifiedItems());
        for (ExtendedProperty extendedProperty : propertiesToSet) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getSetFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getXmlElementName());
            extendedProperty.writeToXml(writer, "ExtendedProperty");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (ExtendedProperty extendedProperty : this.getRemovedItems()) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeEndElement();
        }
        return true;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) throws XMLStreamException, ServiceXmlSerializationException {
        for (ExtendedProperty extendedProperty : this.getItems()) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeEndElement();
        }
        return true;
    }
}

