/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.sync;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.sync.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeCollection<TChange extends Change>
implements Iterable<TChange> {
    private List<TChange> changes = new ArrayList<TChange>();
    private String syncState;
    private boolean moreChangesAvailable;

    public void add(TChange change) {
        EwsUtilities.ewsAssert(change != null, "ChangeList.Add", "change is null");
        this.changes.add(change);
    }

    public int getCount() {
        return this.changes.size();
    }

    public TChange getChangeAtIndex(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
        }
        return (TChange)((Change)this.changes.get(index));
    }

    public String getSyncState() {
        return this.syncState;
    }

    public void setSyncState(String syncState) {
        this.syncState = syncState;
    }

    public boolean getMoreChangesAvailable() {
        return this.moreChangesAvailable;
    }

    public void setMoreChangesAvailable(boolean moreChangesAvailable) {
        this.moreChangesAvailable = moreChangesAvailable;
    }

    @Override
    public Iterator<TChange> iterator() {
        return this.changes.iterator();
    }
}

