/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.extension.exchange.service.util.CalendarConverterUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CorrespondenceService
implements Serializable {
    private static final long serialVersionUID = 4155183714826625091L;
    private static final Log LOG = ExoLogger.getLogger(CorrespondenceService.class);
    private static final String EXCHANGE_NODE_NAME = "calendar-exchange-extension";
    private Map<String, Properties> propertiesMap = new HashMap<String, Properties>();
    private transient NodeHierarchyCreator hierarchyCreator;
    private transient SessionProviderService sessionProviderService;

    public String getCorrespondingId(String username, String id) throws Exception {
        Properties properties = this.loadCorrespondenceProperties(username);
        return properties.getProperty(id);
    }

    public void setCorrespondingId(String username, String exoId, String exchangeId) throws Exception {
        String oldExoId = this.getCorrespondingId(username, exchangeId);
        String oldExchangeId = this.getCorrespondingId(username, exoId);
        if (oldExoId != null && !oldExoId.equals(exoId) || oldExchangeId != null && !oldExchangeId.equals(exchangeId)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Exchange integration, correspondence service : An old existing ID will be replaced by another one.");
            }
            this.deleteCorrespondingId(username, exchangeId, exoId);
        }
        Properties properties = this.loadCorrespondenceProperties(username);
        properties.setProperty(exchangeId, exoId);
        properties.setProperty(exoId, exchangeId);
        this.saveProperties(username, properties);
    }

    public void deleteCorrespondingId(String username, String exchangeId, String exoId) throws Exception {
        Properties properties = this.loadCorrespondenceProperties(username);
        properties.remove(exchangeId);
        properties.remove(exoId);
        this.saveProperties(username, properties);
    }

    public void deleteCorrespondingId(String username, String id) throws Exception {
        Properties properties = this.loadCorrespondenceProperties(username);
        String secondId = properties.getProperty(id);
        if (secondId != null) {
            properties.remove(id);
            properties.remove(secondId);
            this.saveProperties(username, properties);
        }
    }

    public List<String> getSynchronizedExchangeFolderIds(String username) throws Exception {
        Properties properties = this.loadCorrespondenceProperties(username);
        ArrayList<String> folderIds = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!CalendarConverterUtils.isExchangeCalendarId(name)) continue;
            folderIds.add(properties.getProperty(name));
        }
        return folderIds;
    }

    private void saveProperties(String username, Properties properties) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        properties.store((OutputStream)out, "");
        SessionProvider sessionProvider = this.getSessionProviderService().getSystemSessionProvider(null);
        Node node = this.getHierarchyCreator().getUserApplicationNode(sessionProvider, username);
        if (node == null) {
            throw new IllegalStateException("User application node not found. Please fix this and try later.");
        }
        Session session = node.getSession();
        if (!node.hasNode(EXCHANGE_NODE_NAME)) {
            node = node.addNode(EXCHANGE_NODE_NAME, "nt:resource");
            node.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            node.setProperty("jcr:mimeType", "text/plain");
        } else {
            node = node.getNode(EXCHANGE_NODE_NAME);
        }
        node.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(out.toByteArray()));
        session.save();
    }

    private Properties loadCorrespondenceProperties(String username) throws Exception {
        Properties properties = this.propertiesMap.get(username);
        if (properties == null) {
            properties = new Properties();
            SessionProvider sessionProvider = this.getSessionProviderService().getSystemSessionProvider(null);
            Node node = this.getHierarchyCreator().getUserApplicationNode(sessionProvider, username);
            if (node == null) {
                throw new IllegalStateException("User application node not found. Please fix this and try later.");
            }
            if (node.hasNode(EXCHANGE_NODE_NAME)) {
                node = node.getNode(EXCHANGE_NODE_NAME);
                InputStream inputStream = node.getProperty("jcr:data").getStream();
                properties.load(inputStream);
            }
            this.propertiesMap.put(username, properties);
        }
        return properties;
    }

    public NodeHierarchyCreator getHierarchyCreator() {
        if (this.hierarchyCreator == null) {
            this.hierarchyCreator = (NodeHierarchyCreator)CommonsUtils.getService(NodeHierarchyCreator.class);
        }
        return this.hierarchyCreator;
    }

    public SessionProviderService getSessionProviderService() {
        if (this.sessionProviderService == null) {
            this.sessionProviderService = (SessionProviderService)CommonsUtils.getService(SessionProviderService.class);
        }
        return this.sessionProviderService;
    }
}

