/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.jcr.Node;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.ItemTraversal;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.enumeration.service.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.core.enumeration.sync.ChangeType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRemoteException;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.notification.ItemEvent;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import microsoft.exchange.webservices.data.sync.ChangeCollection;
import microsoft.exchange.webservices.data.sync.ItemChange;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.ExchangeDataStorageService;
import org.exoplatform.extension.exchange.service.ExoDataStorageService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class UserIntegrationFacade {
    private static final String GTN_KEY = "gtnKey";
    private static final String GTN_STORE_PASS = "gtnStorePass";
    public static final String USER_EXCHANGE_SERVER_URL_ATTRIBUTE = "exchange.server.url";
    public static final String USER_EXCHANGE_SERVER_DOMAIN_ATTRIBUTE = "exchange.server.domain";
    public static final String USER_EXCHANGE_USERNAME_ATTRIBUTE = "exchange.username";
    public static final String USER_EXCHANGE_PASSWORD_ATTRIBUTE = "exchange.password";
    public static final Context USER_EXCHANGE_CONTEXT = Context.GLOBAL.id("ADDONS_EXCHANGE_CALENDAR");
    public static final Scope USER_EXCHANGE_SCOPE = Scope.APPLICATION;
    public static final String USER_EXCHANGE_SYNC_STATE_KEY = "ADDONS_EXCHANGE_SYNC_STATE";
    private static final Log LOG = ExoLogger.getLogger(UserIntegrationFacade.class);
    private static final String USER_EXO_HANDLED_ATTRIBUTE = "exo.check.date";
    private static final Map<String, UserIntegrationFacade> instances = new HashMap<String, UserIntegrationFacade>();
    private static AbstractCodec codec;
    private final String username;
    private final int maxFirstSynchronizationDays;
    private final ExchangeService service;
    private final ExoDataStorageService exoStorageService;
    private final ExchangeDataStorageService exchangeStorageService;
    private final CorrespondenceService correspondenceService;
    private final CalendarService calendarService;
    private SettingService settingService;
    private boolean synchIsCurrentlyRunning = false;
    private Date firstSynchronizationUntilDate;

    public UserIntegrationFacade(CalendarService calendarService, ExoDataStorageService exoStorageService, ExchangeDataStorageService exchangeStorageService, CorrespondenceService correspondenceService, ExchangeService service, String username, int maxFirstSynchronizationDays) {
        this.calendarService = calendarService;
        this.exoStorageService = exoStorageService;
        this.exchangeStorageService = exchangeStorageService;
        this.correspondenceService = correspondenceService;
        this.service = service;
        this.username = username;
        this.maxFirstSynchronizationDays = maxFirstSynchronizationDays;
        instances.put(username, this);
        java.util.Calendar untilCalendarDate = java.util.Calendar.getInstance();
        untilCalendarDate.add(5, -maxFirstSynchronizationDays);
        this.firstSynchronizationUntilDate = untilCalendarDate.getTime();
    }

    public static UserIntegrationFacade getInstance(String username) {
        return instances.get(username);
    }

    public CalendarFolder getExchangeCalendar(FolderId folderId) throws Exception {
        return this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
    }

    public List<String> synchronizeFullCalendar(FolderId folderId) throws Exception {
        ArrayList<String> updatedExoEventIds = new ArrayList<String>();
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        Calendar exoCalendar = this.exoStorageService.getUserCalendar(this.username, folder.getId().getUniqueId());
        boolean isNewCalendar = exoCalendar == null;
        String syncState = this.getSynchState(folderId);
        if (syncState == null || isNewCalendar) {
            LOG.debug("Start full exchange calendar synchronization for folderId {} until date {}", new Object[]{folderId.getUniqueId(), this.firstSynchronizationUntilDate});
            Date lastSynchronizedDate = null;
            this.exoStorageService.getOrCreateUserCalendar(this.username, (Folder)folder);
            int offset = 0;
            int pageSize = 30;
            ItemView view = new ItemView(pageSize);
            view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
            view.getOrderBy().add((PropertyDefinitionBase)AppointmentSchema.Start, SortDirection.Descending);
            view.setTraversal(ItemTraversal.Shallow);
            ChangeCollection changeCollection = this.service.syncFolderItems(folderId, PropertySet.FirstClassProperties, null, 1, SyncFolderItemsScope.NormalItems, syncState);
            syncState = changeCollection.getSyncState();
            while (true) {
                FindItemsResults<Item> results = null;
                try {
                    results = this.getItems(folderId, view);
                }
                catch (ServiceRemoteException e) {
                    results = this.getItems(folderId, view);
                }
                lastSynchronizedDate = this.synchronizeExchangeAppointments(updatedExoEventIds, results.getItems());
                if (!results.isMoreAvailable() || this.firstSynchronizationUntilDate.after(lastSynchronizedDate)) break;
                view.setOffset(offset += pageSize);
            }
            LOG.debug("Full exchange calendar synchronization processed successfully for folderId {}, last synchronized event start date: {}", new Object[]{folderId.getUniqueId(), lastSynchronizedDate == null ? "" : lastSynchronizedDate});
            this.setSynchState(folderId, syncState);
        } else {
            LOG.debug((Object)"Synchronize last modified events since last synchronization");
            int countModifiedItems = this.synchronizeExchangeAppointementsByState(folderId, updatedExoEventIds);
            LOG.debug("First synchronization is finished with {} modified/created events", new Object[]{countModifiedItems});
        }
        return updatedExoEventIds;
    }

    private int synchronizeExchangeAppointementsByState(FolderId folderId, List<String> updatedExoEventIds) throws Exception {
        String syncState = this.getSynchState(folderId);
        ChangeCollection changeCollection = this.service.syncFolderItems(folderId, PropertySet.FirstClassProperties, null, 512, SyncFolderItemsScope.NormalItems, syncState);
        syncState = changeCollection.getSyncState();
        int countModifiedItems = changeCollection.getCount();
        ArrayList<Item> modifiedItems = new ArrayList<Item>();
        for (ItemChange action : changeCollection) {
            Item item = action.getItem();
            if (!(item instanceof Appointment)) continue;
            if (ChangeType.Create.equals((Object)action.getChangeType()) || ChangeType.Update.equals((Object)action.getChangeType())) {
                modifiedItems.add(item);
                continue;
            }
            if (!ChangeType.Delete.equals((Object)action.getChangeType())) continue;
            String itemId = item.getId().getUniqueId();
            this.checkAndDeleteExoEvent(itemId);
        }
        if (!modifiedItems.isEmpty()) {
            this.synchronizeExchangeAppointments(updatedExoEventIds, modifiedItems);
        }
        this.setSynchState(folderId, syncState);
        return countModifiedItems;
    }

    public void checkAndDeleteExoEvent(String itemId) throws Exception {
        String eventId = this.correspondenceService.getCorrespondingId(this.username, itemId);
        CalendarEvent calendarEvent = this.exoStorageService.getEvent(eventId, this.username);
        if (calendarEvent != null) {
            this.exoStorageService.deleteEvent(this.username, calendarEvent);
        }
    }

    private void setSynchState(FolderId folderId, String syncState) {
        this.getSettingService().set(USER_EXCHANGE_CONTEXT, USER_EXCHANGE_SCOPE.id(folderId.getUniqueId()), USER_EXCHANGE_SYNC_STATE_KEY, SettingValue.create((String)syncState));
    }

    public String getSynchState(FolderId folderId) {
        SettingValue settingValue = this.getSettingService().get(USER_EXCHANGE_CONTEXT, USER_EXCHANGE_SCOPE.id(folderId.getUniqueId()), USER_EXCHANGE_SYNC_STATE_KEY);
        return settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
    }

    public SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    public void synchronizeModificationsOfCalendar(FolderId folderId, Date exoLastSyncDate, List<String> updatedExoEventIDs) throws Exception {
        this.synchronizeExchangeAppointementsByState(folderId, updatedExoEventIDs);
        this.synchronizeExoEventsByModificationDate(folderId, updatedExoEventIDs, exoLastSyncDate);
    }

    public List<FolderId> getAllExchangeCalendars() throws Exception {
        return this.exchangeStorageService.getAllExchangeCalendars(this.service);
    }

    public boolean isCalendarSynchronizedWithExchange(String id) throws Exception {
        return StringUtils.isNotBlank((CharSequence)id) && this.correspondenceService.getCorrespondingId(this.username, id) != null;
    }

    public boolean isCalendarPresentInExo(FolderId folderId) throws Exception {
        return this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId()) != null;
    }

    public List<CalendarEvent> createOrUpdateOrDelete(ItemEvent itemEvent) throws Exception {
        List<CalendarEvent> updatedEvents = null;
        Item item = this.exchangeStorageService.getItem(this.service, itemEvent.getItemId());
        if (item == null) {
            this.exoStorageService.deleteEventByAppointmentID(itemEvent.getItemId().getUniqueId(), this.username);
        } else if (item instanceof Appointment) {
            Appointment appointment = (Appointment)item;
            String eventId = this.correspondenceService.getCorrespondingId(this.username, appointment.getId().getUniqueId());
            updatedEvents = eventId == null ? this.exoStorageService.createEvent(appointment, this.username) : this.exoStorageService.updateEvent(appointment, this.username);
        }
        return updatedEvents;
    }

    public Calendar getUserCalendarByExchangeFolderId(FolderId folderId) throws Exception {
        return this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId());
    }

    public void updateOrCreateExchangeCalendarEvent(Node eventNode) throws Exception {
        CalendarEvent event = this.exoStorageService.getExoEventByNode(eventNode);
        if (this.isCalendarSynchronizedWithExchange(event.getCalendarId())) {
            this.updateOrCreateExchangeCalendarEvent(event);
        }
    }

    public boolean updateOrCreateExchangeCalendarEvent(String eventId) throws Exception {
        CalendarEvent event = ((CalendarServiceImpl)this.calendarService).getDataStorage().getEvent(this.username, eventId);
        return this.updateOrCreateExchangeCalendarEvent(event);
    }

    public boolean updateOrCreateExchangeCalendarEvent(CalendarEvent event) throws Exception {
        String exoMasterId = null;
        if (event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence().booleanValue() && (exoMasterId = this.exoStorageService.getExoEventMasterRecurenceByOriginalUUID(event.getOriginalReference())) == null) {
            LOG.error((Object)("No master Id was found for occurence: " + event.getSummary() + " with recurrenceId = " + event.getRecurrenceId() + ". The event will not be updated."));
        }
        return this.exchangeStorageService.updateOrCreateExchangeAppointment(this.username, this.service, event, exoMasterId, this::appointmentUpdated);
    }

    public void deleteExchangeCalendarEvent(String eventId, String calendarId) throws Exception {
        this.exchangeStorageService.deleteAppointmentByExoEventId(this.username, this.service, eventId, calendarId);
    }

    public boolean deleteExoCalendar(FolderId folderId) throws Exception {
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        if (folder != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Folder was found, but event seems saying that it was deleted.");
            }
            return false;
        }
        return this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
    }

    public void deleteExchangeCalendar(String calendarId) throws Exception {
        this.exchangeStorageService.deleteExchangeFolderByCalenarId(this.username, this.service, calendarId);
    }

    public void removeInstance() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Stop Exchange Integration Service for user: " + this.username));
        }
        instances.remove(this.username);
    }

    public List<String> synchronizeExchangeFolderState(List<FolderId> calendarFolderIds, boolean synchronizeAllExchangeFolders, boolean deleteExoCalendarOnUnsync) throws Exception {
        Iterator<FolderId> iterator = calendarFolderIds.iterator();
        while (iterator.hasNext()) {
            FolderId folderId = iterator.next();
            this.deleteExoCalendarOutOfSync(deleteExoCalendarOnUnsync, iterator, folderId);
        }
        List<String> updatedCalendarEventIds = null;
        if (synchronizeAllExchangeFolders) {
            List<FolderId> folderIds = this.exchangeStorageService.getAllExchangeCalendars(this.service);
            for (FolderId folderId : folderIds) {
                if (calendarFolderIds.contains(folderId)) continue;
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
                List<String> tmpUpdatedCalendarEventIds = this.synchronizeFullCalendar(folderId);
                if (tmpUpdatedCalendarEventIds != null && !tmpUpdatedCalendarEventIds.isEmpty()) {
                    if (updatedCalendarEventIds == null) {
                        updatedCalendarEventIds = tmpUpdatedCalendarEventIds;
                    } else {
                        updatedCalendarEventIds.addAll(tmpUpdatedCalendarEventIds);
                    }
                }
                calendarFolderIds.add(folderId);
            }
        } else {
            List<FolderId> synchronizedFolderIds = this.getSynchronizedExchangeCalendars();
            for (FolderId folderId : synchronizedFolderIds) {
                if (calendarFolderIds.contains(folderId)) continue;
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
                List<String> tmpUpdatedCalendarEventIds = this.synchronizeFullCalendar(folderId);
                if (tmpUpdatedCalendarEventIds != null && !tmpUpdatedCalendarEventIds.isEmpty()) {
                    if (updatedCalendarEventIds == null) {
                        updatedCalendarEventIds = tmpUpdatedCalendarEventIds;
                    } else {
                        updatedCalendarEventIds.addAll(tmpUpdatedCalendarEventIds);
                    }
                }
                calendarFolderIds.add(folderId);
            }
            Iterator<FolderId> folderIdIterator = calendarFolderIds.iterator();
            while (folderIdIterator.hasNext()) {
                FolderId folderId;
                folderId = folderIdIterator.next();
                if (synchronizedFolderIds.contains(folderId)) continue;
                folderIdIterator.remove();
            }
        }
        return updatedCalendarEventIds;
    }

    private void deleteExoCalendarOutOfSync(boolean deleteExoCalendarOnUnsync, Iterator<FolderId> iterator, FolderId folderId) throws Exception {
        Calendar calendar;
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        if (folder == null && (folder = this.exchangeStorageService.getExchangeCalendar(this.service, FolderId.getFolderIdFromWellKnownFolderName((WellKnownFolderName)WellKnownFolderName.Calendar))) != null && (calendar = this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId())) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Folder '" + folderId.getUniqueId() + "' was deleted from Exchange, stopping synchronization for this folder."));
            }
            if (deleteExoCalendarOnUnsync) {
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
            } else {
                this.correspondenceService.deleteCorrespondingId(this.username, folderId.getUniqueId());
            }
            iterator.remove();
        }
    }

    public List<FolderId> getSynchronizedExchangeCalendars() throws Exception {
        ArrayList<FolderId> folderIds = new ArrayList<FolderId>();
        List<String> folderIdsString = this.correspondenceService.getSynchronizedExchangeFolderIds(this.username);
        for (String folderIdString : folderIdsString) {
            folderIds.add(FolderId.getFolderIdFromString((String)folderIdString));
        }
        return folderIds;
    }

    public void addFolderToSynchronization(String folderIdString) throws Exception {
        String calendarId = CalendarConverterUtils.getCalendarId(folderIdString);
        this.correspondenceService.setCorrespondingId(this.username, calendarId, folderIdString);
    }

    public void deleteFolderFromSynchronization(String folderIdString) throws Exception {
        this.correspondenceService.deleteCorrespondingId(this.username, folderIdString);
    }

    public synchronized boolean setSynchronizationStarted() {
        return this.synchIsCurrentlyRunning ? false : (this.synchIsCurrentlyRunning = true);
    }

    public synchronized void setSynchronizationStopped() {
        this.synchIsCurrentlyRunning = false;
    }

    private void deleteExoEventsOutOfSynchronization(FolderId folderId) throws Exception {
        List<CalendarEvent> events = this.exoStorageService.getUserCalendarEvents(this.username, folderId.getUniqueId());
        for (CalendarEvent calendarEvent : events) {
            String itemId = this.correspondenceService.getCorrespondingId(this.username, calendarEvent.getId());
            if (itemId == null) {
                this.exoStorageService.deleteEvent(this.username, calendarEvent);
                continue;
            }
            Item item = this.exchangeStorageService.getItem(this.service, itemId);
            if (item != null) continue;
            this.exoStorageService.deleteEvent(this.username, calendarEvent);
        }
    }

    private Date synchronizeExchangeAppointments(List<String> eventIds, Iterable<Item> items) throws Exception, ServiceLocalException {
        Date lastSynchronizedDate = null;
        for (Item item : items) {
            if (item instanceof Appointment) {
                List<CalendarEvent> updatedEvents;
                Appointment appointment = (Appointment)item;
                if (lastSynchronizedDate == null || lastSynchronizedDate.before(appointment.getStart())) {
                    lastSynchronizedDate = appointment.getStart();
                }
                if ((updatedEvents = this.exoStorageService.createOrUpdateEvent((Appointment)item, this.username)) == null || updatedEvents.isEmpty()) continue;
                for (CalendarEvent calendarEvent : updatedEvents) {
                    eventIds.add(calendarEvent.getId());
                }
                continue;
            }
            LOG.warn((Object)("Item bound from exchange but not of type 'Appointment':" + item.getItemClass()));
        }
        return lastSynchronizedDate;
    }

    public void setUserExoLastCheckDate(long time) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Set last time check for modified exo events to '{}.{}' for user {}", new Object[]{new Date(time), time % 1000L, this.username});
        }
        this.getSettingService().set(USER_EXCHANGE_CONTEXT, USER_EXCHANGE_SCOPE.id(this.username), USER_EXO_HANDLED_ATTRIBUTE, SettingValue.create((String)String.valueOf(time)));
    }

    public Date getUserExoLastCheckDate() throws Exception {
        SettingValue settingValue = this.getSettingService().get(USER_EXCHANGE_CONTEXT, USER_EXCHANGE_SCOPE.id(this.username), USER_EXO_HANDLED_ATTRIBUTE);
        if (settingValue == null || settingValue.getValue() == null) {
            return null;
        }
        long time = Long.parseLong(settingValue.getValue().toString());
        return new Date(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserArrtibute(OrganizationService organizationService, String username, String name, String value) throws Exception {
        if (organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile;
            if (USER_EXCHANGE_PASSWORD_ATTRIBUTE.equals(name)) {
                value = UserIntegrationFacade.encodePassword(value);
            }
            if ((userProfile = organizationService.getUserProfileHandler().findUserProfileByName(username)) == null) {
                userProfile = organizationService.getUserProfileHandler().createUserProfileInstance(username);
                organizationService.getUserProfileHandler().saveUserProfile(userProfile, true);
            }
            userProfile.setAttribute(name, value);
            organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
        }
        finally {
            if (organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserArrtibute(OrganizationService organizationService, String username, String name) throws Exception {
        if (organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile = organizationService.getUserProfileHandler().findUserProfileByName(username);
            String value = null;
            if (userProfile != null && (value = userProfile.getAttribute(name)) != null && USER_EXCHANGE_PASSWORD_ATTRIBUTE.equals(name)) {
                value = UserIntegrationFacade.decodePassword(value);
            }
            String string = value;
            return string;
        }
        finally {
            if (organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    public ExchangeService getService() {
        return this.service;
    }

    private void synchronizeExoEventsByModificationDate(FolderId folderId, List<String> updatedExoEventIDs, Date exoLastSyncDate) throws Exception {
        List<CalendarEvent> modifiedCalendarEvents = this.searchCalendarEventsModifiedSince(this.getUserCalendarByExchangeFolderId(folderId), exoLastSyncDate);
        if (LOG.isTraceEnabled() && modifiedCalendarEvents.size() > 0) {
            LOG.trace("Check exo user calendar for user '{}' since '{}', items found: {}", new Object[]{this.username, exoLastSyncDate, modifiedCalendarEvents.size()});
        }
        for (CalendarEvent calendarEvent : modifiedCalendarEvents) {
            boolean deleteEvent;
            if (updatedExoEventIDs.contains(calendarEvent.getId())) continue;
            String exoMasterId = null;
            if (calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue() && (exoMasterId = this.exoStorageService.getExoEventMasterRecurenceByOriginalUUID(calendarEvent.getOriginalReference())) == null) {
                LOG.error((Object)("No master Id was found for occurence: " + calendarEvent.getSummary() + " with recurrenceId = " + calendarEvent.getRecurrenceId() + ". The event will not be updated."));
            }
            if (deleteEvent = this.exchangeStorageService.updateOrCreateExchangeAppointment(this.username, this.service, calendarEvent, exoMasterId, this::appointmentUpdated)) {
                this.exoStorageService.deleteEvent(this.username, calendarEvent);
            }
            updatedExoEventIDs.add(calendarEvent.getId());
        }
    }

    private FindItemsResults<Item> getItems(FolderId parentFolderId, ItemView view) throws Exception {
        try {
            return this.service.findItems(parentFolderId, view);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while paging results: page = " + view.getOffset() + " page size = " + view.getPageSize()), (Throwable)e);
            return null;
        }
    }

    private List<CalendarEvent> searchCalendarEventsModifiedSince(Calendar calendar, Date date) throws Exception {
        if (date == null) {
            return this.exoStorageService.getAllExoEvents(this.username, calendar);
        }
        return this.exoStorageService.findExoEventsModifiedSince(this.username, calendar, date);
    }

    private List<Item> searchAllAppointmentsModifiedSince(FolderId parentFolderId, Date date) throws Exception {
        if (date == null) {
            throw new IllegalArgumentException("since date is null");
        }
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        ItemView view = new ItemView(100);
        view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
        FindItemsResults findResults = this.service.findItems(parentFolderId, (SearchFilter)new SearchFilter.IsGreaterThan((PropertyDefinitionBase)ItemSchema.LastModifiedTime, (Object)calendar.getTime()), view);
        int totalCount = findResults.getTotalCount();
        if (LOG.isTraceEnabled() && totalCount > 0) {
            LOG.trace("Check exchange user calendar for user '{}' since '{}', items found: {}", new Object[]{this.username, date, totalCount});
        }
        return findResults.getItems();
    }

    private static void initCodec() throws TokenServiceInitializationException {
        HashMap<String, String> config;
        String builderType;
        block35: {
            builderType = PropertyManager.getProperty((String)"gatein.codec.builderclass");
            config = new HashMap<String, String>();
            if (builderType != null) {
                String configFilePath = PropertyManager.getProperty((String)"gatein.codec.config");
                File configFile = new File(configFilePath);
                try (FileInputStream in = new FileInputStream(configFile);){
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.put("gatein.codec.config.basedir", configFile.getParentFile().getAbsolutePath());
                    break block35;
                }
                catch (IOException e) {
                    throw new TokenServiceInitializationException("Failed to read the config parameters from file '" + configFilePath + "'.", (Throwable)e);
                }
            }
            builderType = "org.exoplatform.web.security.codec.JCASymmetricCodecBuilder";
            String gtnConfDir = PropertyManager.getProperty((String)"gatein.conf.dir");
            if (gtnConfDir == null || gtnConfDir.length() == 0) {
                throw new TokenServiceInitializationException("'gatein.conf.dir' property must be set.");
            }
            File f = new File(gtnConfDir + "/codec/codeckey.txt");
            if (!f.exists()) {
                File codecDir = f.getParentFile();
                if (!codecDir.exists()) {
                    codecDir.mkdir();
                }
                try (FileOutputStream out = new FileOutputStream(f);){
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(128);
                    SecretKey key = keyGen.generateKey();
                    KeyStore store = KeyStore.getInstance("JCEKS");
                    store.load(null, GTN_STORE_PASS.toCharArray());
                    store.setEntry(GTN_KEY, new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection("gtnKeyPass".toCharArray()));
                    store.store(out, GTN_STORE_PASS.toCharArray());
                }
                catch (Exception e) {
                    throw new TokenServiceInitializationException((Throwable)e);
                }
            }
            config.put("gatein.codec.jca.symmetric.keyalg", "AES");
            config.put("gatein.codec.jca.symmetric.keystore", "codeckey.txt");
            config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
            config.put("gatein.codec.jca.symmetric.alias", GTN_KEY);
            config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
            config.put("gatein.codec.jca.symmetric.storepass", GTN_STORE_PASS);
            config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
        }
        try {
            codec = Class.forName(builderType).asSubclass(AbstractCodecBuilder.class).newInstance().build(config);
        }
        catch (Exception e) {
            throw new TokenServiceInitializationException("Could not initialize CookieTokenService.codec.", (Throwable)e);
        }
    }

    private static String decodePassword(String password) throws TokenServiceInitializationException {
        if (codec == null) {
            UserIntegrationFacade.initCodec();
        }
        return codec.decode(password);
    }

    private static String encodePassword(String password) throws TokenServiceInitializationException {
        if (codec == null) {
            UserIntegrationFacade.initCodec();
        }
        return codec.encode(password);
    }

    public Boolean appointmentUpdated(Appointment appointment) {
        try {
            appointment = (Appointment)this.exchangeStorageService.getItem(this.service, appointment.getId());
            CalendarEvent event = this.exoStorageService.getEventByAppointmentId(this.username, appointment.getId().getUniqueId());
            if (event != null) {
                this.exoStorageService.updateModifiedDateOfEvent(this.username, event, appointment.getLastModifiedTime());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error occurred while updating eXo Event last updated date", (Throwable)e);
            return false;
        }
        return true;
    }
}

