/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.StandardUser;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.DelegatePermissions;
import microsoft.exchange.webservices.data.property.complex.UserId;

public final class DelegateUser
extends ComplexProperty {
    private UserId userId = new UserId();
    private DelegatePermissions permissions = new DelegatePermissions();
    private boolean receiveCopiesOfMeetingMessages = false;
    private boolean viewPrivateItems = false;

    public DelegateUser() {
    }

    public DelegateUser(String primarySmtpAddress) {
        this();
        this.userId.setPrimarySmtpAddress(primarySmtpAddress);
    }

    public DelegateUser(StandardUser standardUser) {
        this();
        this.userId.setStandardUser(standardUser);
    }

    public UserId getUserId() {
        return this.userId;
    }

    public DelegatePermissions getPermissions() {
        return this.permissions;
    }

    public boolean getReceiveCopiesOfMeetingMessages() {
        return this.receiveCopiesOfMeetingMessages;
    }

    public void setReceiveCopiesOfMeetingMessages(boolean value) {
        this.receiveCopiesOfMeetingMessages = value;
    }

    public boolean getViewPrivateItems() {
        return this.viewPrivateItems;
    }

    public void setViewPrivateItems(boolean value) {
        this.viewPrivateItems = value;
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("UserId")) {
            this.userId = new UserId();
            this.userId.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("UserId")) {
            this.permissions.reset();
            this.permissions.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("ReceiveCopiesOfMeetingMessages")) {
            this.receiveCopiesOfMeetingMessages = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("ViewPrivateItems")) {
            this.viewPrivateItems = reader.readElementValue(Boolean.class);
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getUserId().writeToXml(writer, "UserId");
        this.getPermissions().writeToXml(writer, "DelegatePermissions");
        writer.writeElementValue(XmlNamespace.Types, "ReceiveCopiesOfMeetingMessages", this.receiveCopiesOfMeetingMessages);
        writer.writeElementValue(XmlNamespace.Types, "ViewPrivateItems", this.viewPrivateItems);
    }

    protected void internalValidate() throws ServiceValidationException {
        if (this.getUserId() == null) {
            throw new ServiceValidationException("The UserId in the DelegateUser hasn't been specified.");
        }
        if (!this.getUserId().isValid()) {
            throw new ServiceValidationException("The UserId in the DelegateUser is invalid. The StandardUser, PrimarySmtpAddress or SID property must be set.");
        }
    }

    protected void validateAddDelegate() throws ServiceValidationException, Exception {
        this.permissions.validateAddDelegate();
    }

    public void validateUpdateDelegate() throws Exception {
        this.permissions.validateUpdateDelegate();
    }
}

