/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.EmailAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.MailboxType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.core.service.schema.ContactGroupSchema;
import microsoft.exchange.webservices.data.property.complex.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.GroupMember;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.definition.GroupMemberPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupMemberCollection
extends ComplexPropertyCollection<GroupMember>
implements ICustomXmlUpdateSerializer {
    private boolean collectionIsCleared = false;

    @Override
    protected String getCollectionItemXmlElementName(GroupMember member) {
        return "Member";
    }

    public GroupMember find(String key) throws Exception {
        EwsUtilities.validateParam(key, "key");
        for (GroupMember item : this.getItems()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }

    public void clear() {
        this.internalClear();
        this.collectionIsCleared = true;
    }

    public void add(GroupMember member) throws Exception {
        EwsUtilities.validateParam(member, "member");
        EwsUtilities.ewsAssert(member.getKey() == null, "GroupMemberCollection.Add", "member.Key is not null.");
        EwsUtilities.ewsAssert(!this.contains(member), "GroupMemberCollection.Add", "The member is already in the collection");
        this.internalAdd(member);
    }

    public void addRange(Iterator<GroupMember> members) throws Exception {
        EwsUtilities.validateParam(members, "members");
        while (members.hasNext()) {
            this.add(members.next());
        }
    }

    public void addContactGroup(ItemId contactGroupId) throws Exception {
        this.add(new GroupMember(contactGroupId));
    }

    public void addPersonalContact(ItemId contactId, String addressToLink) throws Exception {
        this.add(new GroupMember(contactId, addressToLink));
    }

    public void addPersonalContact(ItemId contactId) throws Exception {
        this.addPersonalContact(contactId, null);
    }

    public void addDirectoryUser(String smtpAddress) throws ServiceLocalException, Exception {
        this.addDirectoryUser(smtpAddress, new EmailAddress().getSmtpRoutingType());
    }

    public void addDirectoryUser(String address, String routingType) throws ServiceLocalException, Exception {
        this.add(new GroupMember(address, routingType, MailboxType.Mailbox));
    }

    public void addDirectoryContact(String smtpAddress) throws ServiceLocalException, Exception {
        this.addDirectoryContact(smtpAddress, new EmailAddress().getSmtpRoutingType());
    }

    public void addDirectoryContact(String address, String routingType) throws ServiceLocalException, Exception {
        this.add(new GroupMember(address, routingType, MailboxType.Contact));
    }

    public void addPublicGroup(String smtpAddress) throws ServiceLocalException, Exception {
        this.add(new GroupMember(smtpAddress, new EmailAddress().getSmtpRoutingType(), MailboxType.PublicGroup));
    }

    public void addDirectoryPublicFolder(String smtpAddress) throws ServiceLocalException, Exception {
        this.add(new GroupMember(smtpAddress, new EmailAddress().getSmtpRoutingType(), MailboxType.PublicFolder));
    }

    public void addOneOff(String displayName, String address, String routingType) throws Exception {
        this.add(new GroupMember(displayName, address, routingType));
    }

    public void addOneOff(String displayName, String smtpAddress) throws Exception {
        this.addOneOff(displayName, smtpAddress, new EmailAddress().getSmtpRoutingType());
    }

    public void addContactEmailAddress(Contact contact, EmailAddressKey emailAddressKey) throws Exception {
        this.add(new GroupMember(contact, emailAddressKey));
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException("index", new Throwable("index is out of range."));
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(GroupMember member) {
        return this.internalRemove(member);
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ownerObject, PropertyDefinition propertyDefinition) throws Exception {
        if (this.collectionIsCleared) {
            if (!this.getAddedItems().isEmpty()) {
                this.writeDeleteMembersCollectionToXml(writer);
            } else {
                this.writeSetOrAppendMembersToXml(writer, this.getAddedItems(), true);
            }
        } else {
            this.writeSetOrAppendMembersToXml(writer, this.getAddedItems(), false);
            this.writeDeleteMembersToXml(writer, this.getModifiedItems());
            this.writeSetOrAppendMembersToXml(writer, this.getModifiedItems(), false);
            this.writeDeleteMembersToXml(writer, this.getRemovedItems());
        }
        return true;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) {
        return false;
    }

    @Override
    protected GroupMember createComplexProperty(String xmlElementName) {
        return new GroupMember();
    }

    @Override
    public void clearChangeLog() {
        super.clearChangeLog();
        this.collectionIsCleared = false;
    }

    private void writeDeleteMembersCollectionToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "DeleteItemField");
        ContactGroupSchema.Members.writeToXml(writer);
        writer.writeEndElement();
    }

    private void writeDeleteMembersToXml(EwsServiceXmlWriter writer, List<GroupMember> members) throws XMLStreamException, ServiceXmlSerializationException {
        if (!members.isEmpty()) {
            GroupMemberPropertyDefinition memberPropDef = new GroupMemberPropertyDefinition();
            for (GroupMember member : members) {
                writer.writeStartElement(XmlNamespace.Types, "DeleteItemField");
                memberPropDef.setKey(member.getKey());
                memberPropDef.writeToXml(writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeSetOrAppendMembersToXml(EwsServiceXmlWriter writer, List<GroupMember> members, boolean setMode) throws Exception {
        if (!members.isEmpty()) {
            writer.writeStartElement(XmlNamespace.Types, setMode ? "SetItemField" : "AppendToItemField");
            ContactGroupSchema.Members.writeToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, "DistributionList");
            writer.writeStartElement(XmlNamespace.Types, "Members");
            for (GroupMember member : members) {
                member.writeToXml(writer, "Member");
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    @Override
    protected void internalValidate() throws Exception {
        super.internalValidate();
        for (GroupMember groupMember : this.getModifiedItems()) {
            if (groupMember.getKey() == null || groupMember.getKey().isEmpty()) continue;
            throw new ServiceValidationException("The contact group's Members property must be reloaded before newly-added members can be updated.");
        }
    }
}

