/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.ICreateComplexPropertyDelegate;
import microsoft.exchange.webservices.data.property.complex.IOwnedProperty;
import microsoft.exchange.webservices.data.property.definition.ComplexPropertyDefinitionBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexPropertyDefinition<TComplexProperty extends ComplexProperty>
extends ComplexPropertyDefinitionBase {
    private Class<TComplexProperty> instance;
    private ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate;

    public ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, flags, version);
        this.instance = cls;
        EwsUtilities.ewsAssert(propertyCreationDelegate != null, "ComplexPropertyDefinition ctor", "CreateComplexPropertyDelegate cannot be null");
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    public ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, version);
        this.instance = cls;
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    public ComplexPropertyDefinition(String xmlElementName, String uri, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, version);
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    public ComplexPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, uri, flags, version);
        this.instance = cls;
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    public ComplexPropertyDefinition(String attachments, String xmlElementName, ExchangeVersion version, EnumSet<PropertyDefinitionFlags> flags, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(xmlElementName, attachments, flags, version);
        this.propertyCreationDelegate = propertyCreationDelegate;
    }

    @Override
    public ComplexProperty createPropertyInstance(ServiceObject owner) {
        TComplexProperty complexProperty = this.propertyCreationDelegate.createComplexProperty();
        if (complexProperty instanceof IOwnedProperty) {
            IOwnedProperty ownedProperty = (IOwnedProperty)complexProperty;
            ownedProperty.setOwner(owner);
        }
        return complexProperty;
    }

    public Class<TComplexProperty> getType() {
        return this.instance;
    }
}

