/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.io.Serializable;
import java.text.ParseException;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypedPropertyDefinition<T extends Serializable>
extends PropertyDefinition {
    private boolean isNullable;

    protected TypedPropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
        this.isNullable = false;
    }

    protected TypedPropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    protected TypedPropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, boolean isNullable) {
        super(xmlElementName, uri, flags, version);
        this.isNullable = isNullable;
    }

    protected abstract T parse(String var1) throws InstantiationException, IllegalAccessException, ParseException;

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    protected String toString(T value) {
        return value.toString();
    }

    @Override
    public void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        String value = reader.readElementValue(XmlNamespace.Types, this.getXmlElement());
        if (value != null && !value.isEmpty()) {
            propertyBag.setObjectFromPropertyDefinition(this, this.parse(value));
        }
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws XMLStreamException, ServiceLocalException {
        Serializable value = (Serializable)propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            writer.writeElementValue(XmlNamespace.Types, this.getXmlElement(), this.getName(), value);
        }
    }
}

