/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.search.ItemTraversal;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.ViewBase;

public final class CalendarView
extends ViewBase {
    private ItemTraversal traversal = ItemTraversal.Shallow;
    private Integer maxItemsReturned;
    private Date startDate;
    private Date endDate;

    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Traversal", (Object)this.getTraversal());
    }

    protected void internalWriteSearchSettingsToXml(EwsServiceXmlWriter writer, Grouping groupBy) {
    }

    public void writeOrderByToXml(EwsServiceXmlWriter writer) {
    }

    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Item;
    }

    public CalendarView(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public CalendarView(Date startDate, Date endDate, int maxItemsReturned) {
        this(startDate, endDate);
        this.maxItemsReturned = maxItemsReturned;
    }

    public void internalValidate(ServiceRequestBase request) throws ServiceVersionException, ServiceValidationException {
        super.internalValidate(request);
        if (this.endDate.compareTo(this.startDate) < 0) {
            throw new ServiceValidationException("EndDate must be greater than StartDate.");
        }
    }

    protected void internalWriteViewToXml(EwsServiceXmlWriter writer) throws Exception {
        super.internalWriteViewToXml(writer);
        writer.writeAttributeValue("StartDate", this.startDate);
        writer.writeAttributeValue("EndDate", this.endDate);
    }

    protected String getViewXmlElementName() {
        return "CalendarView";
    }

    protected Integer getMaxEntriesReturned() {
        return this.maxItemsReturned;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getMaxItemsReturned() {
        return this.maxItemsReturned;
    }

    public void setMaxItemsReturned(Integer maxItemsReturned) throws ArgumentException {
        if (maxItemsReturned != null && maxItemsReturned <= 0) {
            throw new ArgumentException("The value must be greater than 0.");
        }
        this.maxItemsReturned = maxItemsReturned;
    }

    public ItemTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(ItemTraversal traversal) {
        this.traversal = traversal;
    }
}

