/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.request;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.ConversationAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplyConversationActionRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private List<ConversationAction> conversationActions = new ArrayList<ConversationAction>();

    public List<ConversationAction> getConversationActions() {
        return this.conversationActions;
    }

    public ApplyConversationActionRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.conversationActions.size();
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.conversationActions.iterator(), "conversationActions");
        for (int iAction = 0; iAction < this.getConversationActions().size(); ++iAction) {
            this.getConversationActions().get(iAction).validate();
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ConversationActions");
        for (int iAction = 0; iAction < this.getConversationActions().size(); ++iAction) {
            this.getConversationActions().get(iAction).writeElementsToXml(writer);
        }
        writer.writeEndElement();
    }

    @Override
    public String getXmlElementName() {
        return "ApplyConversationAction";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ApplyConversationActionResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ApplyConversationActionResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }
}

