/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.Collection;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.CreateRequest;
import microsoft.exchange.webservices.data.core.response.CreateFolderResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.folder.Folder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateFolderRequest
extends CreateRequest<Folder, ServiceResponse> {
    public CreateFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolders(), "Folders");
        for (Folder folder : this.getFolders()) {
            folder.validate();
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new CreateFolderResponse((Folder)EwsUtilities.getEnumeratedObjectAt(this.getFolders(), responseIndex));
    }

    @Override
    public String getXmlElementName() {
        return "CreateFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "CreateFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "CreateFolderResponseMessage";
    }

    @Override
    protected String getParentFolderXmlElementName() {
        return "ParentFolderId";
    }

    @Override
    protected String getObjectCollectionXmlElementName() {
        return "Folders";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public Iterable<Folder> getFolders() {
        return this.getObjects();
    }

    public void setFolders(Iterable<Folder> folder) {
        this.setObjects((Collection)folder);
    }
}

