/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.GetServerTimeZonesResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetServerTimeZonesRequest
extends MultiResponseServiceRequest<GetServerTimeZonesResponse> {
    private Iterable<String> ids;

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.ids != null) {
            EwsUtilities.validateParamCollection(this.getIds().iterator(), "Ids");
        }
    }

    public GetServerTimeZonesRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected GetServerTimeZonesResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetServerTimeZonesResponse();
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetServerTimeZonesResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "GetServerTimeZones";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetServerTimeZonesResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        if (this.getIds() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Ids");
            for (String id : this.getIds()) {
                writer.writeElementValue(XmlNamespace.Types, "Id", id);
            }
            writer.writeEndElement();
        }
    }

    protected Iterable<String> getIds() {
        return this.ids;
    }

    protected void setIds(Iterable<String> ids) {
        this.ids = ids;
    }
}

