/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.enumeration.property.OofExternalAudience;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.GetUserOofSettingsResponse;
import microsoft.exchange.webservices.data.property.complex.availability.OofSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetUserOofSettingsRequest
extends SimpleServiceRequestBase<GetUserOofSettingsResponse> {
    private String smtpAddress;

    @Override
    public String getXmlElementName() {
        return "GetUserOofSettingsRequest";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getSmtpAddress(), "SmtpAddress");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Mailbox");
        writer.writeElementValue(XmlNamespace.Types, "Address", this.getSmtpAddress());
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserOofSettingsResponse";
    }

    @Override
    protected GetUserOofSettingsResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        GetUserOofSettingsResponse serviceResponse = new GetUserOofSettingsResponse();
        serviceResponse.loadFromXml(reader, "ResponseMessage");
        if (serviceResponse.getErrorCode() == ServiceError.NoError) {
            reader.readStartElement(XmlNamespace.Types, "OofSettings");
            serviceResponse.setOofSettings(new OofSettings());
            serviceResponse.getOofSettings().loadFromXml(reader, reader.getLocalName());
            serviceResponse.getOofSettings().setAllowExternalOof(reader.readElementValue(OofExternalAudience.class, XmlNamespace.Messages, "AllowExternalOof"));
        }
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public GetUserOofSettingsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    public GetUserOofSettingsResponse execute() throws Exception {
        GetUserOofSettingsResponse serviceResponse = (GetUserOofSettingsResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    protected String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }
}

