/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.http.HTTPException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeServerInfo;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.DateTimePrecision;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.http.HttpErrorException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.exception.xml.XmlException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.SoapFaultDetails;
import microsoft.exchange.webservices.data.security.XmlNodeType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceRequestBase<T> {
    private static final Log LOG = LogFactory.getLog(ServiceRequestBase.class);
    private ExchangeService service;

    public abstract String getXmlElementName();

    protected abstract String getResponseXmlElementName();

    protected abstract ExchangeVersion getMinimumRequiredServerVersion();

    protected abstract T parseResponse(EwsServiceXmlReader var1) throws Exception;

    protected abstract void writeElementsToXml(EwsServiceXmlWriter var1) throws Exception;

    protected void validate() throws Exception {
        this.service.validate();
    }

    protected void writeBodyToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, this.getXmlElementName());
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
    }

    protected ServiceRequestBase(ExchangeService service) throws ServiceVersionException {
        this.service = service;
        this.throwIfNotSupportedByRequestedServerVersion();
    }

    public ExchangeService getService() {
        return this.service;
    }

    protected void throwIfNotSupportedByRequestedServerVersion() throws ServiceVersionException {
        if (this.service.getRequestedServerVersion().ordinal() < this.getMinimumRequiredServerVersion().ordinal()) {
            throw new ServiceVersionException(String.format("The service request %s is only valid for Exchange version %s or later.", new Object[]{this.getXmlElementName(), this.getMinimumRequiredServerVersion()}));
        }
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartDocument();
        writer.writeStartElement(XmlNamespace.Soap, "Envelope");
        writer.writeAttributeValue("xmlns", EwsUtilities.getNamespacePrefix(XmlNamespace.Soap), (Object)EwsUtilities.getNamespaceUri(XmlNamespace.Soap));
        writer.writeAttributeValue("xmlns", "xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttributeValue("xmlns", "m", (Object)"http://schemas.microsoft.com/exchange/services/2006/messages");
        writer.writeAttributeValue("xmlns", "t", (Object)"http://schemas.microsoft.com/exchange/services/2006/types");
        if (writer.isRequireWSSecurityUtilityNamespace()) {
            writer.writeAttributeValue("xmlns", "wsu", (Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        writer.writeStartElement(XmlNamespace.Soap, "Header");
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().emitExtraSoapHeaderNamespaceAliases(writer.getInternalWriter());
        }
        writer.writeStartElement(XmlNamespace.Types, "RequestServerVersion");
        writer.writeAttributeValue("Version", this.getRequestedServiceVersionString());
        writer.writeEndElement();
        if (this.service.getPreferredCulture() != null) {
            writer.writeElementValue(XmlNamespace.Types, "MailboxCulture", this.service.getPreferredCulture().getDisplayName());
        }
        if (this.getService().getDateTimePrecision().ordinal() != DateTimePrecision.Default.ordinal()) {
            writer.writeElementValue(XmlNamespace.Types, "DateTimePrecision", this.getService().getDateTimePrecision().toString());
        }
        if (this.service.getImpersonatedUserId() != null) {
            this.service.getImpersonatedUserId().writeToXml(writer);
        }
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().serializeExtraSoapHeaders(writer.getInternalWriter(), this.getXmlElementName());
        }
        this.service.doOnSerializeCustomSoapHeaders(writer.getInternalWriter());
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Soap, "Body");
        this.writeBodyToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.flush();
    }

    private String getRequestedServiceVersionString() {
        if (this.service.getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1 && this.service.getExchange2007CompatibilityMode()) {
            return "Exchange2007";
        }
        return this.service.getRequestedServerVersion().toString();
    }

    protected static InputStream getResponseStream(HttpWebRequest request) throws IOException, EWSHttpException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getInputStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getInputStream()) : request.getInputStream());
        return responseStream;
    }

    protected void traceResponse(HttpWebRequest request, ByteArrayOutputStream memoryStream) throws XMLStreamException, IOException, EWSHttpException {
        this.service.processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, request);
        String contentType = request.getResponseContentType();
        if (!this.isNullOrEmpty(contentType) && (contentType.startsWith("text/") || contentType.startsWith("application/soap"))) {
            this.service.traceXml(TraceFlags.EwsResponse, memoryStream);
        } else {
            this.service.traceMessage(TraceFlags.EwsResponse, "Non-textual response");
        }
    }

    private static InputStream getResponseErrorStream(HttpWebRequest request) throws EWSHttpException, IOException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getErrorStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getErrorStream()) : request.getErrorStream());
        return responseStream;
    }

    protected T readResponse(HttpWebRequest response) throws Exception {
        if (!response.getResponseContentType().startsWith("text/xml")) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.");
        }
        try {
            InputStream responseStream;
            T serviceResponse;
            this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponse)) {
                ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                InputStream serviceResponseStream = ServiceRequestBase.getResponseStream(response);
                int data = serviceResponseStream.read();
                while (data != -1) {
                    memoryStream.write(data);
                    data = serviceResponseStream.read();
                }
                this.traceResponse(response, memoryStream);
                ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(memoryStreamIn, this.getService());
                serviceResponse = this.readResponse(ewsXmlReader);
                serviceResponseStream.close();
                memoryStream.flush();
            } else {
                responseStream = ServiceRequestBase.getResponseStream(response);
                EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(responseStream, this.getService());
                serviceResponse = this.readResponse(ewsXmlReader);
            }
            responseStream = serviceResponse;
            return (T)responseStream;
        }
        catch (HTTPException e) {
            if (e.getMessage() != null) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            }
            throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), e);
        }
        finally {
            response.close();
        }
    }

    protected T readResponse(EwsServiceXmlReader ewsXmlReader) throws Exception {
        this.readPreamble(ewsXmlReader);
        ewsXmlReader.readStartElement(XmlNamespace.Soap, "Envelope");
        this.readSoapHeader(ewsXmlReader);
        ewsXmlReader.readStartElement(XmlNamespace.Soap, "Body");
        ewsXmlReader.readStartElement(XmlNamespace.Messages, this.getResponseXmlElementName());
        T serviceResponse = this.parseResponse(ewsXmlReader);
        ewsXmlReader.readEndElementIfNecessary(XmlNamespace.Messages, this.getResponseXmlElementName());
        ewsXmlReader.readEndElement(XmlNamespace.Soap, "Body");
        ewsXmlReader.readEndElement(XmlNamespace.Soap, "Envelope");
        return serviceResponse;
    }

    protected void readPreamble(EwsServiceXmlReader ewsXmlReader) throws Exception {
        this.readXmlDeclaration(ewsXmlReader);
    }

    private void readSoapHeader(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Soap, "Header");
        do {
            reader.read();
            if (!reader.isStartElement(XmlNamespace.Types, "ServerVersionInfo")) continue;
            this.service.setServerInfo(ExchangeServerInfo.parse(reader));
        } while (!reader.isEndElement(XmlNamespace.Soap, "Header"));
    }

    protected void processWebException(Exception webException, HttpWebRequest req) throws Exception {
        if (null != req) {
            this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, req);
            if (500 == req.getResponseCode()) {
                SoapFaultDetails soapFaultDetails;
                if (this.service.isTraceEnabledFor(TraceFlags.EwsResponse)) {
                    int data;
                    ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                    InputStream serviceResponseStream = ServiceRequestBase.getResponseErrorStream(req);
                    while (-1 != (data = serviceResponseStream.read())) {
                        memoryStream.write(data);
                    }
                    memoryStream.flush();
                    serviceResponseStream.close();
                    this.traceResponse(req, memoryStream);
                    ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                    EwsServiceXmlReader reader = new EwsServiceXmlReader(memoryStreamIn, this.service);
                    soapFaultDetails = this.readSoapFault(reader);
                    memoryStream.close();
                } else {
                    InputStream serviceResponseStream = ServiceRequestBase.getResponseStream(req);
                    EwsServiceXmlReader reader = new EwsServiceXmlReader(serviceResponseStream, this.service);
                    soapFaultDetails = this.readSoapFault(reader);
                    serviceResponseStream.close();
                }
                if (soapFaultDetails != null) {
                    switch (soapFaultDetails.getResponseCode()) {
                        case ErrorInvalidServerVersion: {
                            throw new ServiceVersionException("Exchange Server doesn't support the requested version.");
                        }
                        case ErrorSchemaValidation: {
                            if (this.service.getServerInfo() == null || this.service.getServerInfo().getMajorVersion() != 8 || this.service.getServerInfo().getMinorVersion() != 0) break;
                            throw new ServiceVersionException("Exchange Server doesn't support the requested version.");
                        }
                        case ErrorIncorrectSchemaVersion: {
                            EwsUtilities.ewsAssert(false, "ServiceRequestBase.ProcessWebException", "Exchange server supports requested version but request was invalid for that version");
                            break;
                        }
                    }
                    throw new ServiceResponseException(new ServiceResponse(soapFaultDetails));
                }
            } else {
                this.service.processHttpErrorResponse(req, webException);
            }
        }
    }

    protected SoapFaultDetails readSoapFault(EwsServiceXmlReader reader) {
        SoapFaultDetails soapFaultDetails = null;
        try {
            this.readXmlDeclaration(reader);
            reader.read();
            if (!reader.isStartElement() || !reader.getLocalName().equals("Envelope")) {
                return soapFaultDetails;
            }
            XmlNamespace soapNamespace = EwsUtilities.getNamespaceFromUri(reader.getNamespaceUri());
            if (soapNamespace == XmlNamespace.NotSpecified) {
                return soapFaultDetails;
            }
            reader.read();
            if (reader.isStartElement(soapNamespace, "Header")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Types, "ServerVersionInfo")) continue;
                    this.service.setServerInfo(ExchangeServerInfo.parse(reader));
                } while (!reader.isEndElement(soapNamespace, "Header"));
                reader.read();
            }
            if (reader.isStartElement(soapNamespace, "Body")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(soapNamespace, "Fault")) continue;
                    soapFaultDetails = SoapFaultDetails.parse(reader, soapNamespace);
                } while (!reader.isEndElement(soapNamespace, "Body"));
            }
            reader.readEndElement(soapNamespace, "Envelope");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return soapFaultDetails;
    }

    protected HttpWebRequest validateAndEmitRequest() throws Exception {
        this.validate();
        HttpWebRequest request = this.service.getMaximumPoolingConnections() > 1 ? this.buildEwsHttpPoolingWebRequest() : this.buildEwsHttpWebRequest();
        try {
            try {
                return this.getEwsHttpWebResponse(request);
            }
            catch (HttpErrorException e) {
                this.processWebException(e, request);
                throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), e);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)request);
            throw e;
        }
    }

    protected HttpWebRequest buildEwsHttpWebRequest() throws Exception {
        HttpWebRequest request = this.service.prepareHttpWebRequest();
        return this.buildEwsHttpWebRequest(request);
    }

    protected HttpWebRequest buildEwsHttpPoolingWebRequest() throws Exception {
        HttpWebRequest request = this.service.prepareHttpPoolingWebRequest();
        return this.buildEwsHttpWebRequest(request);
    }

    private HttpWebRequest buildEwsHttpWebRequest(HttpWebRequest request) throws Exception {
        try {
            this.service.traceHttpRequestHeaders(TraceFlags.EwsRequestHttpHeaders, request);
            ByteArrayOutputStream requestStream = (ByteArrayOutputStream)request.getOutputStream();
            EwsServiceXmlWriter writer = new EwsServiceXmlWriter(this.service, requestStream);
            boolean needSignature = this.service.getCredentials() != null && this.service.getCredentials().isNeedSignature();
            writer.setRequireWSSecurityUtilityNamespace(needSignature);
            this.writeToXml(writer);
            if (needSignature) {
                this.service.getCredentials().sign(requestStream);
            }
            this.service.traceXml(TraceFlags.EwsRequest, requestStream);
            return request;
        }
        catch (IOException e) {
            throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), e);
        }
    }

    protected HttpWebRequest getEwsHttpWebResponse(HttpWebRequest request) throws Exception {
        try {
            request.executeRequest();
            if (request.getResponseCode() >= 400) {
                throw new HttpErrorException("The remote server returned an error: (" + request.getResponseCode() + ")" + request.getResponseText(), request.getResponseCode());
            }
        }
        catch (IOException e) {
            throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), e);
        }
        return request;
    }

    private boolean isNullOrEmpty(String str) {
        return null == str || str.isEmpty();
    }

    private void readXmlDeclaration(EwsServiceXmlReader reader) throws Exception {
        try {
            reader.read(new XmlNodeType(7));
        }
        catch (XmlException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
        catch (ServiceXmlDeserializationException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
    }
}

