/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.security.XmlNodeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapFaultDetails {
    private static final Log LOG = LogFactory.getLog(SoapFaultDetails.class);
    private String faultCode;
    private String faultString;
    private String faultActor;
    private ServiceError responseCode = ServiceError.ErrorInternalServerError;
    private String message;
    private ServiceError errorCode = ServiceError.NoError;
    private String exceptionType;
    private int lineNumber;
    private int positionWithinLine;
    private Map<String, String> errorDetails = new HashMap<String, String>();

    public static SoapFaultDetails parse(EwsXmlReader reader, XmlNamespace soapNamespace) throws Exception {
        SoapFaultDetails soapFaultDetails = new SoapFaultDetails();
        do {
            reader.read();
            if (!reader.getNodeType().equals(new XmlNodeType(1))) continue;
            String localName = reader.getLocalName();
            if (localName.equals("faultcode")) {
                soapFaultDetails.setFaultCode(reader.readElementValue());
                continue;
            }
            if (localName.equals("faultstring")) {
                soapFaultDetails.setFaultString(reader.readElementValue());
                continue;
            }
            if (localName.equals("faultactor")) {
                soapFaultDetails.setFaultActor(reader.readElementValue());
                continue;
            }
            if (!localName.equals("detail")) continue;
            soapFaultDetails.parseDetailNode(reader);
        } while (!reader.isEndElement(soapNamespace, "Fault"));
        return soapFaultDetails;
    }

    private void parseDetailNode(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (!reader.getNodeType().equals(new XmlNodeType(1))) continue;
            String localName = reader.getLocalName();
            if (localName.equals("ResponseCode")) {
                try {
                    this.setResponseCode(reader.readElementValue(ServiceError.class));
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    this.setResponseCode(ServiceError.ErrorInternalServerError);
                }
                continue;
            }
            if (localName.equals("Message")) {
                this.setMessage(reader.readElementValue());
                continue;
            }
            if (localName.equals("Line")) {
                this.setLineNumber(reader.readElementValue(Integer.class));
                continue;
            }
            if (localName.equals("Position")) {
                this.setPositionWithinLine(reader.readElementValue(Integer.class));
                continue;
            }
            if (localName.equals("ErrorCode")) {
                try {
                    this.setErrorCode(reader.readElementValue(ServiceError.class));
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    this.setErrorCode(ServiceError.ErrorInternalServerError);
                }
                continue;
            }
            if (localName.equals("ExceptionType")) {
                try {
                    this.setExceptionType(reader.readElementValue());
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    this.setExceptionType(null);
                }
                continue;
            }
            if (!localName.equals("MessageXml")) continue;
            this.parseMessageXml(reader);
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "detail"));
    }

    private void parseMessageXml(EwsXmlReader reader) throws Exception, ServiceXmlDeserializationException, Exception {
        XmlNamespace elementNS = EwsUtilities.getNamespaceFromUri(reader.getNamespaceUri());
        if (!reader.isEmptyElement()) {
            do {
                String localName;
                reader.read();
                if (!reader.isStartElement() || reader.isEmptyElement() || !(localName = reader.getLocalName()).equals("Value")) continue;
                this.errorDetails.put(reader.readAttributeValue("Name"), reader.readElementValue());
            } while (!reader.isEndElement(elementNS, "MessageXml"));
        } else {
            reader.read();
        }
    }

    protected String getFaultCode() {
        return this.faultCode;
    }

    protected void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    protected void setFaultString(String faultString) {
        this.faultString = faultString;
    }

    protected String getFaultActor() {
        return this.faultActor;
    }

    protected void setFaultActor(String faultActor) {
        this.faultActor = faultActor;
    }

    public ServiceError getResponseCode() {
        return this.responseCode;
    }

    protected void setResponseCode(ServiceError responseCode) {
        this.responseCode = responseCode;
    }

    protected String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected ServiceError getErrorCode() {
        return this.errorCode;
    }

    protected void setErrorCode(ServiceError errorCode) {
        this.errorCode = errorCode;
    }

    protected String getExceptionType() {
        return this.exceptionType;
    }

    protected void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    protected int getPositionWithinLine() {
        return this.positionWithinLine;
    }

    protected void setPositionWithinLine(int positionWithinLine) {
        this.positionWithinLine = positionWithinLine;
    }

    public Map<String, String> getErrorDetails() {
        return this.errorDetails;
    }

    protected void setErrorDetails(Map<String, String> errorDetails) {
        this.errorDetails = errorDetails;
    }
}

