/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Arrays;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.IServiceObjectChangedDelegate;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemAttachment
extends Attachment
implements IServiceObjectChangedDelegate {
    private static final Log LOG = LogFactory.getLog(ItemAttachment.class);
    private Item item;

    protected ItemAttachment(Item owner) {
        super(owner);
    }

    public Item getItem() {
        return this.item;
    }

    protected void setItem(Item item) {
        this.throwIfThisIsNotNew();
        if (this.item != null) {
            this.item.removeServiceObjectChangedEvent(this);
        }
        this.item = item;
        if (this.item != null) {
            this.item.addServiceObjectChangedEvent(this);
        }
    }

    private void itemChanged(ServiceObject serviceObject) {
        this.item.getPropertyBag().changed();
    }

    @Override
    public String getXmlElementName() {
        return "ItemAttachment";
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        boolean result = super.tryReadElementFromXml(reader);
        if (!result) {
            this.item = EwsUtilities.createItemFromXmlElementName(this, reader.getLocalName());
            if (this.item != null) {
                try {
                    this.item.loadFromXml(reader, true);
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        }
        return result;
    }

    @Override
    public boolean tryReadElementFromXmlToPatch(EwsServiceXmlReader reader) throws Exception {
        super.tryReadElementFromXml(reader);
        reader.read();
        String localName = reader.getLocalName();
        Class<?> itemClass = EwsUtilities.getItemTypeFromXmlElementName(localName);
        if (itemClass != null) {
            if (this.item == null || this.item.getClass() != itemClass) {
                throw new ServiceLocalException("Attachment item type mismatch.");
            }
            this.item.loadFromXml(reader, false);
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        try {
            this.item.writeToXml(writer);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @Override
    protected void validate(int attachmentIndex) throws Exception {
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new ServiceValidationException(String.format("The name of the item attachment at index %d must be set.", attachmentIndex));
        }
        this.validate();
    }

    public void load(PropertyDefinitionBase ... additionalProperties) throws Exception {
        this.internalLoad(null, Arrays.asList(additionalProperties));
    }

    public void load(Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        this.internalLoad(null, additionalProperties);
    }

    public void load(BodyType bodyType, PropertyDefinitionBase ... additionalProperties) throws Exception {
        this.internalLoad(bodyType, Arrays.asList(additionalProperties));
    }

    public void load(BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        this.internalLoad(bodyType, additionalProperties);
    }

    @Override
    public void serviceObjectChanged(ServiceObject serviceObject) {
        this.itemChanged(serviceObject);
    }
}

