/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.Time;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.TimeChangeRecurrence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeChange
extends ComplexProperty {
    private static final Log LOG = LogFactory.getLog(TimeChange.class);
    private String timeZoneName;
    private TimeSpan offset;
    private Time time;
    private Date absoluteDate;
    private TimeChangeRecurrence recurrence;

    public TimeChange() {
    }

    public TimeChange(TimeSpan offset) {
        this();
        this.offset = offset;
    }

    public TimeChange(TimeSpan offset, Time time) {
        this(offset);
        this.time = time;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
    }

    public TimeSpan getOffset() {
        return this.offset;
    }

    public void setOffset(TimeSpan offset) {
        this.offset = offset;
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public Date getAbsoluteDate() {
        return this.absoluteDate;
    }

    public void setAbsoluteDate(Date absoluteDate) {
        this.absoluteDate = absoluteDate;
        if (absoluteDate != null) {
            this.recurrence = null;
        }
    }

    public TimeChangeRecurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(TimeChangeRecurrence recurrence) {
        this.recurrence = recurrence;
        if (this.recurrence != null) {
            this.absoluteDate = null;
        }
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Offset")) {
            this.offset = EwsUtilities.getXSDurationToTimeSpan(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("RelativeYearlyRecurrence")) {
            this.recurrence = new TimeChangeRecurrence();
            this.recurrence.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("AbsoluteDate")) {
            Calendar cal = DatatypeConverter.parseDate((String)reader.readElementValue());
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.absoluteDate = cal.getTime();
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("Time")) {
            Calendar cal = DatatypeConverter.parseTime((String)reader.readElementValue());
            this.time = new Time(cal.getTime());
            return true;
        }
        return false;
    }

    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.timeZoneName = reader.readAttributeValue("TimeZoneName");
    }

    public void writeAttributesToXml(EwsServiceXmlWriter writer) {
        try {
            writer.writeAttributeValue("TimeZoneName", this.timeZoneName);
        }
        catch (ServiceXmlSerializationException e) {
            LOG.error((Object)e);
        }
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.offset != null) {
            writer.writeElementValue(XmlNamespace.Types, "Offset", EwsUtilities.getTimeSpanToXSDuration(this.getOffset()));
        }
        if (this.recurrence != null) {
            this.recurrence.writeToXml(writer, "RelativeYearlyRecurrence");
        }
        if (this.absoluteDate != null) {
            writer.writeElementValue(XmlNamespace.Types, "AbsoluteDate", EwsUtilities.dateTimeToXSDate(this.getAbsoluteDate()));
        }
        if (this.time != null) {
            writer.writeElementValue(XmlNamespace.Types, "Time", this.getTime().toXSTime());
        }
    }
}

