/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.availability;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.OofExternalAudience;
import microsoft.exchange.webservices.data.core.enumeration.property.OofState;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.availability.OofReply;
import microsoft.exchange.webservices.data.misc.availability.TimeWindow;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public final class OofSettings
extends ComplexProperty
implements ISelfValidate {
    private OofState state = OofState.Disabled;
    private OofExternalAudience externalAudience = OofExternalAudience.None;
    private OofExternalAudience allowExternalOof = OofExternalAudience.None;
    private TimeWindow duration;
    private OofReply internalReply;
    private OofReply externalReply;

    private void serializeOofReply(OofReply oofReply, EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        if (oofReply != null) {
            oofReply.writeToXml(writer, xmlElementName);
        } else {
            OofReply.writeEmptyReplyToXml(writer, xmlElementName);
        }
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("OofState")) {
            this.state = reader.readValue(OofState.class);
            return true;
        }
        if (reader.getLocalName().equals("ExternalAudience")) {
            this.externalAudience = reader.readValue(OofExternalAudience.class);
            return true;
        }
        if (reader.getLocalName().equals("Duration")) {
            this.duration = new TimeWindow();
            this.duration.loadFromXml(reader);
            return true;
        }
        if (reader.getLocalName().equals("InternalReply")) {
            this.internalReply = new OofReply();
            this.internalReply.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("ExternalReply")) {
            this.externalReply = new OofReply();
            this.externalReply.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "OofState", (Object)this.getState());
        writer.writeElementValue(XmlNamespace.Types, "ExternalAudience", (Object)this.getExternalAudience());
        if (this.getDuration() != null && this.getState() == OofState.Scheduled) {
            this.getDuration().writeToXml(writer, "Duration");
        }
        this.serializeOofReply(this.getInternalReply(), writer, "InternalReply");
        this.serializeOofReply(this.getExternalReply(), writer, "ExternalReply");
    }

    public OofState getState() {
        return this.state;
    }

    public void setState(OofState state) {
        this.state = state;
    }

    public OofExternalAudience getExternalAudience() {
        return this.externalAudience;
    }

    public void setExternalAudience(OofExternalAudience externalAudience) {
        this.externalAudience = externalAudience;
    }

    public TimeWindow getDuration() {
        return this.duration;
    }

    public void setDuration(TimeWindow duration) {
        this.duration = duration;
    }

    public OofReply getInternalReply() {
        return this.internalReply;
    }

    public void setInternalReply(OofReply internalReply) {
        this.internalReply = internalReply;
    }

    public OofReply getExternalReply() {
        return this.externalReply;
    }

    public void setExternalReply(OofReply externalReply) {
        this.externalReply = externalReply;
    }

    public OofExternalAudience getAllowExternalOof() {
        return this.allowExternalOof;
    }

    public void setAllowExternalOof(OofExternalAudience allowExternalOof) {
        this.allowExternalOof = allowExternalOof;
    }

    public void validate() throws Exception {
        if (this.getState() == OofState.Scheduled) {
            if (this.getDuration() == null) {
                throw new ArgumentException("Duration must be specified when State is equal to Scheduled.");
            }
            EwsUtilities.validateParam(this.getDuration(), "Duration");
        }
    }
}

