/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.response;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.response.ResponseObject;
import microsoft.exchange.webservices.data.misc.CalendarActionResults;
import microsoft.exchange.webservices.data.property.complex.FolderId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class CalendarResponseMessageBase<TMessage extends EmailMessage>
extends ResponseObject<TMessage> {
    CalendarResponseMessageBase(Item referenceItem) throws Exception {
        super(referenceItem);
    }

    public CalendarActionResults calendarSave(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return new CalendarActionResults(this.internalCreate(destinationFolderId, MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSave(WellKnownFolderName destinationFolderName) throws Exception {
        return new CalendarActionResults(this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSave() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSend() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SendOnly));
    }

    public CalendarActionResults calendarSendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return new CalendarActionResults(this.internalCreate(destinationFolderId, MessageDisposition.SendAndSaveCopy));
    }

    public CalendarActionResults calendarSendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        return new CalendarActionResults(this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy));
    }

    public CalendarActionResults calendarSendAndSaveCopy() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SendAndSaveCopy));
    }
}

