/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public class ByteArrayArray
extends ComplexProperty {
    static final String ItemXmlElementName = "Base64Binary";
    private List<byte[]> content = new ArrayList<byte[]>();

    public byte[][] getContent() {
        return (byte[][])this.content.toArray();
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase(ItemXmlElementName)) {
            this.content.add(reader.readBase64ElementValue());
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        for (byte[] item : this.content) {
            writer.writeStartElement(XmlNamespace.Types, ItemXmlElementName);
            writer.writeBase64ElementValue(item);
            writer.writeEndElement();
        }
    }
}

