/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public final class RulePredicateDateRange
extends ComplexProperty {
    private Date start;
    private Date end;

    protected RulePredicateDateRange() {
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date value) {
        if (this.canSetFieldValue(this.start, value)) {
            this.start = value;
            this.changed();
        }
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date value) {
        if (this.canSetFieldValue(this.end, value)) {
            this.end = value;
            this.changed();
        }
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("StartDateTime")) {
            this.start = reader.readElementValueAsDateTime();
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("EndDateTime")) {
            this.end = reader.readElementValueAsDateTime();
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        if (this.getStart() != null) {
            writer.writeElementValue(XmlNamespace.Types, "StartDateTime", this.getStart());
        }
        if (this.getEnd() != null) {
            writer.writeElementValue(XmlNamespace.Types, "EndDateTime", this.getEnd());
        }
    }

    protected void internalValidate() throws ServiceValidationException, Exception {
        super.internalValidate();
        if (this.start != null && this.end != null && this.start.after(this.end)) {
            throw new ServiceValidationException("Start date time cannot be bigger than end date time.");
        }
    }
}

