/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.time.AbsoluteMonthTransition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZonePeriod;

class AbsoluteDayOfMonthTransition
extends AbsoluteMonthTransition {
    private int dayOfMonth;

    protected String getXmlElementName() {
        return "RecurringDateTransition";
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("Day")) {
            this.dayOfMonth = reader.readElementValue(Integer.class);
            EwsUtilities.ewsAssert(this.dayOfMonth > 0 && this.dayOfMonth <= 31, "AbsoluteDayOfMonthTransition.TryReadElementFromXml", "dayOfMonth is not in the valid 1 - 31 range.");
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "Day", this.dayOfMonth);
    }

    protected AbsoluteDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected int getDayOfMonth() {
        return this.dayOfMonth;
    }
}

