/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.ICreateComplexPropertyDelegate;
import microsoft.exchange.webservices.data.property.definition.ComplexPropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainedPropertyDefinition<TComplexProperty extends ComplexProperty>
extends ComplexPropertyDefinition<TComplexProperty> {
    private String containedXmlElementName;

    public ContainedPropertyDefinition(Class<TComplexProperty> cls, String xmlElementName, String uri, String containedXmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, ICreateComplexPropertyDelegate<TComplexProperty> propertyCreationDelegate) {
        super(cls, xmlElementName, uri, flags, version, propertyCreationDelegate);
        this.containedXmlElementName = containedXmlElementName;
    }

    @Override
    protected void internalLoadFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        reader.readStartElement(XmlNamespace.Types, this.containedXmlElementName);
        super.internalLoadFromXml(reader, propertyBag);
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.containedXmlElementName);
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object o = propertyBag.getObjectFromPropertyDefinition(this);
        if (o instanceof ComplexProperty) {
            ComplexProperty complexProperty = (ComplexProperty)o;
            writer.writeStartElement(XmlNamespace.Types, this.getXmlElement());
            complexProperty.writeToXml(writer, this.containedXmlElementName);
            writer.writeEndElement();
        }
    }
}

