/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.Date;
import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.util.DateTimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimePropertyDefinition
extends PropertyDefinition {
    private boolean isNullable;

    public DateTimePropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
    }

    public DateTimePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    public DateTimePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version, boolean isNullable) {
        super(xmlElementName, uri, flags, version);
        this.isNullable = isNullable;
    }

    @Override
    public void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        String value = reader.readElementValue(XmlNamespace.Types, this.getXmlElement());
        propertyBag.setObjectFromPropertyDefinition(this, DateTimeUtils.convertDateTimeStringToDate(value));
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object value = propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            writer.writeStartElement(XmlNamespace.Types, this.getXmlElement());
            Date dateTime = (Date)value;
            writer.writeValue(EwsUtilities.dateTimeToXSDateTime(dateTime), this.getName());
            writer.writeEndElement();
        }
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public Class<Date> getType() {
        return Date.class;
    }
}

