/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.definition.ServiceObjectPropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedPropertyDefinition
extends ServiceObjectPropertyDefinition {
    private String index;

    public IndexedPropertyDefinition(String uri, String index) {
        super(uri);
        this.index = index;
    }

    protected static boolean isEqualTo(IndexedPropertyDefinition idxPropDef1, IndexedPropertyDefinition idxPropDef2) {
        return idxPropDef1 == idxPropDef2 || idxPropDef1 != null && idxPropDef2 != null && idxPropDef1.getUri().equalsIgnoreCase(idxPropDef2.getUri()) && idxPropDef1.index.equalsIgnoreCase(idxPropDef2.index);
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("FieldIndex", this.getIndex());
    }

    @Override
    protected String getXmlElementName() {
        return "IndexedFieldURI";
    }

    @Override
    public String getPrintableName() {
        return String.format("%s:%s", this.getUri(), this.getIndex());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexedPropertyDefinition) {
            return IndexedPropertyDefinition.isEqualTo((IndexedPropertyDefinition)obj, this);
        }
        return false;
    }

    public int hashCode() {
        return this.getUri().hashCode() ^ this.getIndex().hashCode();
    }

    public Class<String> getType() {
        return String.class;
    }
}

