/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import microsoft.exchange.webservices.data.CalendarFolder;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.ExchangeCredentials;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderEvent;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.GetEventsResults;
import microsoft.exchange.webservices.data.ItemEvent;
import microsoft.exchange.webservices.data.PullSubscription;
import microsoft.exchange.webservices.data.WebCredentials;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.ExchangeStorageService;
import org.exoplatform.extension.exchange.service.ExoStorageService;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;

public class IntegrationListener
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(IntegrationListener.class);
    private static final String EXCHANGE_SERVER_URL_PARAM_NAME = "exchange.ews.url";
    private static final String EXCHANGE_DOMAIN_PARAM_NAME = "exchange.domain";
    private static final String EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME = "exchange.scheduler.delay";
    private static final String EXCHANGE_SYNCHRONIZE_ALL = "exchange.synchronize.all.folders";
    private static final String EXCHANGE_DELETE_CALENDAR_ON_UNSYNC = "exchange.delete.calendar.on.unsync";
    public static short diffTimeZone = 0;
    private static long threadIndex = 0L;
    private static int schedulerDelayInSeconds = 0;
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(10);
    private final Map<String, ScheduledFuture<?>> futures = new HashMap();
    private final Map<String, Runnable> runnables = new HashMap<String, Runnable>();
    private final ExoStorageService exoStorageService;
    private final ExchangeStorageService exchangeStorageService;
    private final CorrespondenceService correspondenceService;
    private final OrganizationService organizationService;
    private final CalendarService calendarService;
    private final IdentityRegistry identityRegistry;
    public String exchangeServerURL = null;
    public String exchangeDomain = null;
    private boolean synchronizeAllExchangeFolders = false;
    private boolean deleteExoCalendarOnUnsync = false;

    public IntegrationListener(OrganizationService organizationService, CalendarService calendarService, ExoStorageService exoStorageService, ExchangeStorageService exchangeStorageService, CorrespondenceService correspondenceService, IdentityRegistry identityRegistry, InitParams params) {
        String exchangeSynchronizeAllString;
        String deleteExoCalendarOnUnsyncString;
        this.exoStorageService = exoStorageService;
        this.exchangeStorageService = exchangeStorageService;
        this.correspondenceService = correspondenceService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
        this.calendarService = calendarService;
        if (params.containsKey((Object)EXCHANGE_SERVER_URL_PARAM_NAME) && !params.getValueParam(EXCHANGE_SERVER_URL_PARAM_NAME).getValue().isEmpty()) {
            this.exchangeServerURL = params.getValueParam(EXCHANGE_SERVER_URL_PARAM_NAME).getValue();
        } else {
            LOG.warn((Object)"Echange Synchronization Service: init-param exchange.ews.urlis not set.");
        }
        if (params.containsKey((Object)EXCHANGE_DOMAIN_PARAM_NAME) && !params.getValueParam(EXCHANGE_DOMAIN_PARAM_NAME).getValue().isEmpty()) {
            this.exchangeDomain = params.getValueParam(EXCHANGE_DOMAIN_PARAM_NAME).getValue();
        } else {
            LOG.warn((Object)"Echange Synchronization Service: init-param exchange.domainis not set.");
        }
        if (params.containsKey((Object)EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME)) {
            String schedulerDelayInSecondsString = params.getValueParam(EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME).getValue();
            schedulerDelayInSeconds = Integer.valueOf(schedulerDelayInSecondsString);
        }
        if (schedulerDelayInSeconds < 10) {
            LOG.warn((Object)"Echange Synchronization Service: init-param exchange.scheduler.delayis not correctly set. Use default: 30.");
            schedulerDelayInSeconds = 30;
        }
        if (params.containsKey((Object)EXCHANGE_SYNCHRONIZE_ALL) && (deleteExoCalendarOnUnsyncString = params.getValueParam(EXCHANGE_SYNCHRONIZE_ALL).getValue()) != null && deleteExoCalendarOnUnsyncString.equals("true")) {
            this.deleteExoCalendarOnUnsync = true;
        }
        if (params.containsKey((Object)EXCHANGE_DELETE_CALENDAR_ON_UNSYNC) && (exchangeSynchronizeAllString = params.getValueParam(EXCHANGE_DELETE_CALENDAR_ON_UNSYNC).getValue()) != null && exchangeSynchronizeAllString.equals("true")) {
            this.synchronizeAllExchangeFolders = true;
        }
        diffTimeZone = this.getTimeZoneDiffWithUTC();
    }

    public void start() {
        LOG.info((Object)"Echange Synchronization Service: Successfully started.");
    }

    public void stop() {
        this.scheduledExecutor.shutdownNow();
    }

    public void userLoggedIn(String username, String password) throws Exception {
        String exchangeStoredUsername = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.username");
        if (exchangeStoredUsername != null && !exchangeStoredUsername.isEmpty()) {
            String exchangeStoredServerName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.url");
            String exchangeStoredDomainName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.domain");
            String exchangeStoredPassword = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.password");
            this.userLoggedIn(username, exchangeStoredUsername, exchangeStoredPassword, exchangeStoredDomainName, exchangeStoredServerName);
        } else if (this.exchangeDomain != null && this.exchangeServerURL != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Exchange Synchronization Service: User '" + username + "' have not yet set parameters, use default Exchange server settings."));
            }
            this.userLoggedIn(username, username, password, this.exchangeDomain, this.exchangeServerURL);
        } else {
            LOG.warn((Object)"Exchange Service is unvailable, please set parameters.");
        }
    }

    public void userLoggedIn(String username, String exchangeUsername, String password, String exchangeDomain, String exchangeServerURL) {
        block3: {
            try {
                Identity identity = this.identityRegistry.getIdentity(username);
                if (identity == null || identity.getUserId().equals(IdentityConstants.ANONIM)) {
                    throw new IllegalStateException("Identity of user '" + username + "' not found.");
                }
                this.closeTaskIfExists(username);
                ExchangeIntegrationTask schedulerCommand = new ExchangeIntegrationTask(identity, exchangeUsername, password, exchangeDomain, exchangeServerURL);
                ScheduledFuture<?> future = this.scheduledExecutor.scheduleWithFixedDelay(schedulerCommand, 10L, schedulerDelayInSeconds, TimeUnit.SECONDS);
                this.futures.put(username, future);
                this.runnables.put(username, schedulerCommand);
                LOG.info((Object)("User '" + username + "' logged in, exchange synchronization task started."));
            }
            catch (Exception e) {
                LOG.warn((Object)("Exchange integration error for user '" + username + "' : " + e.getMessage()));
                if (!LOG.isTraceEnabled() && !LOG.isDebugEnabled()) break block3;
                LOG.trace((Object)"Error while initializing user integration with exchange: ", (Throwable)e);
            }
        }
    }

    public void userLoggedOut(String username) {
        this.closeTaskIfExists(username);
    }

    public void synchronize(String username) {
        Runnable command = this.runnables.get(username);
        if (command != null) {
            command.run();
        }
    }

    private void closeTaskIfExists(String username) {
        ScheduledFuture<?> future = this.futures.remove(username);
        if (future != null) {
            future.cancel(true);
            IntegrationService integrationService = IntegrationService.getInstance(username);
            if (integrationService != null) {
                try {
                    integrationService.removeInstance();
                }
                catch (Throwable e) {
                    LOG.error((Object)e);
                }
            }
            LOG.info((Object)("Exchange synchronization task stopped for User '" + username + "'."));
        }
    }

    private short getTimeZoneDiffWithUTC() {
        short diffTimeZone = 0;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String dateTimeInOriginalTimeZone = dateFormat.format(date);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTimeInUTCTimeZone = dateFormat.format(date);
        try {
            long timeInOriginalTimeZone = dateFormat.parse(dateTimeInOriginalTimeZone).getTime();
            long timeInUTCTimeZone = dateFormat.parse(dateTimeInUTCTimeZone).getTime();
            diffTimeZone = (short)((timeInUTCTimeZone - timeInOriginalTimeZone) / 60000L);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while calculating difference between UTC Timezone and current one.");
        }
        return diffTimeZone;
    }

    protected class ExchangeIntegrationTask
    extends Thread {
        private IntegrationService integrationService;
        private List<FolderId> calendarFolderIds;
        private PullSubscription subscription;
        private String username;
        private ConversationState state;
        private boolean firstSynchronization;

        public ExchangeIntegrationTask(Identity identity, String exchangeUsername, String exchangePassword, String exchangeDomain, String exchangeServerURL) throws Exception {
            super("ExchangeIntegrationTask-" + threadIndex++);
            this.calendarFolderIds = new ArrayList<FolderId>();
            this.subscription = null;
            this.username = identity.getUserId();
            this.firstSynchronization = true;
            ExchangeService service = new ExchangeService(ExchangeVersion.Exchange2010_SP1, TimeZone.getDefault());
            WebCredentials credentials = new WebCredentials(exchangeUsername, exchangePassword, exchangeDomain);
            service.setCredentials((ExchangeCredentials)credentials);
            service.setUrl(new URI(exchangeServerURL));
            this.integrationService = new IntegrationService(IntegrationListener.this.organizationService, IntegrationListener.this.calendarService, IntegrationListener.this.exoStorageService, IntegrationListener.this.exchangeStorageService, IntegrationListener.this.correspondenceService, service, this.username);
            this.state = new ConversationState(identity);
            ConversationState.setCurrent((ConversationState)this.state);
            if (IntegrationListener.this.synchronizeAllExchangeFolders) {
                this.calendarFolderIds = IntegrationListener.this.exchangeStorageService.getAllExchangeCalendars(service);
            } else {
                CalendarFolder folder = this.integrationService.getExchangeCalendar(FolderId.getFolderIdFromWellKnownFolderName((WellKnownFolderName)WellKnownFolderName.Calendar));
                if (folder != null) {
                    this.integrationService.setSynchronizationStarted();
                    this.calendarFolderIds = this.integrationService.getSynchronizedExchangeCalendars();
                    this.integrationService.setSynchronizationStopped();
                } else {
                    throw new RuntimeException("Error while authenticating user '" + this.username + "' to exchange, please make sure you are connected to the correct URL with correct credentials.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.waitOtherTasks();
            try {
                this.integrationService.setSynchronizationStarted();
                ConversationState.setCurrent((ConversationState)this.state);
                List<String> updatedExoEventIDs = this.integrationService.synchronizeExchangeFolderState(this.calendarFolderIds, IntegrationListener.this.synchronizeAllExchangeFolders, IntegrationListener.this.deleteExoCalendarOnUnsync);
                if (this.calendarFolderIds.isEmpty()) {
                    return;
                }
                if (updatedExoEventIDs == null) {
                    updatedExoEventIDs = new ArrayList<String>();
                }
                Date lastSyncDate = this.integrationService.getUserLastCheckDate();
                if (this.firstSynchronization) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("run first synchronization for user: " + this.username));
                    }
                    this.synchronizeByModificationDate(lastSyncDate, updatedExoEventIDs);
                    this.firstSynchronization = false;
                    this.newSubscription();
                } else {
                    GetEventsResults events;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("run scheduled synchronization for user: " + this.username));
                    }
                    try {
                        events = this.subscription.getEvents();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Subscription seems timed out, retry. Original cause: " + e.getMessage() + ""));
                        this.newSubscription();
                        events = this.subscription.getEvents();
                    }
                    if (IntegrationListener.this.synchronizeAllExchangeFolders) {
                        this.synchronizeExchangeFolders(events, updatedExoEventIDs);
                    }
                    this.synchronizeExchangeApointments(events, updatedExoEventIDs);
                    this.synchronizeByModificationDate(lastSyncDate, updatedExoEventIDs);
                    this.newSubscription();
                }
                long checkTime = java.util.Calendar.getInstance().getTimeInMillis();
                this.integrationService.setUserLastCheckDate(checkTime);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Synchronization completed.");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while synchronizing calndar entries.", (Throwable)e);
            }
            finally {
                this.integrationService.setSynchronizationStopped();
            }
        }

        private void waitOtherTasks() {
            for (int i = 0; this.integrationService.isSynchronizationStarted() && i < 10; ++i) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Exchange integration is in use, scheduled job will wait until synchronization is finished for user:'" + this.username + "'."));
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
        }

        private void synchronizeByModificationDate(Date lastSyncDate, List<String> updatedExoEventIDs) throws Exception {
            for (FolderId folderId : this.calendarFolderIds) {
                Calendar calendar = this.integrationService.getUserCalendarByExchangeFolderId(folderId);
                if (calendar == null || lastSyncDate == null) {
                    this.integrationService.synchronizeFullCalendar(folderId);
                    continue;
                }
                this.integrationService.synchronizeModificationsOfCalendar(folderId, lastSyncDate, updatedExoEventIDs, diffTimeZone);
            }
        }

        private void synchronizeExchangeApointments(GetEventsResults events, List<String> updatedExoEventIDs) throws Exception {
            Iterable itemEvents = events.getItemEvents();
            if (itemEvents.iterator().hasNext()) {
                ArrayList<String> itemIds = new ArrayList<String>();
                for (ItemEvent itemEvent : itemEvents) {
                    if (itemIds.contains(itemEvent.getItemId().getUniqueId())) continue;
                    itemIds.add(itemEvent.getItemId().getUniqueId());
                    List<CalendarEvent> updatedEvents = this.integrationService.createOrUpdateOrDelete(itemEvent);
                    if (updatedEvents == null || updatedEvents.isEmpty() || updatedExoEventIDs == null) continue;
                    for (CalendarEvent calendarEvent : updatedEvents) {
                        updatedExoEventIDs.add(calendarEvent.getId());
                    }
                }
            }
        }

        private void synchronizeExchangeFolders(GetEventsResults events, List<String> updatedExoEventIDs) throws Exception {
            if (events.getFolderEvents() != null && events.getFolderEvents().iterator().hasNext()) {
                for (FolderEvent folderEvent : events.getFolderEvents()) {
                    if (folderEvent.getEventType().equals((Object)EventType.Created) || folderEvent.getEventType().equals((Object)EventType.Modified)) {
                        if (this.integrationService.isCalendarPresentInExo(folderEvent.getFolderId())) continue;
                        List<String> updatedEventIDs = this.integrationService.synchronizeFullCalendar(folderEvent.getFolderId());
                        updatedExoEventIDs.addAll(updatedEventIDs);
                        if (updatedEventIDs.isEmpty() || this.calendarFolderIds.contains(folderEvent.getFolderId())) continue;
                        this.calendarFolderIds.add(folderEvent.getFolderId());
                        continue;
                    }
                    if (folderEvent.getEventType().equals((Object)EventType.Deleted)) {
                        boolean deleted = this.integrationService.deleteExoCalendar(folderEvent.getFolderId());
                        if (!deleted || !this.calendarFolderIds.contains(folderEvent.getFolderId())) continue;
                        this.calendarFolderIds.remove(folderEvent.getFolderId());
                        continue;
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Folder Event wasn't catched: " + folderEvent.getEventType().name() + "on folder: " + folderEvent.getFolderId().getUniqueId()));
                }
            }
        }

        private void newSubscription() throws Exception {
            block4: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("New Subscription for user: " + this.username));
                }
                if (this.subscription != null) {
                    try {
                        this.subscription.unsubscribe();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled() && !LOG.isTraceEnabled()) break block4;
                        LOG.error((Object)"Error while unsubscribe, will renew it anyway.", (Throwable)e);
                    }
                }
            }
            this.subscription = this.integrationService.getService().subscribeToPullNotifications(this.calendarFolderIds, 5, null, new EventType[]{EventType.Modified, EventType.Created, EventType.Deleted});
        }

        @Override
        public void interrupt() {
            if (this.subscription != null) {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Thread interruption: unsubscribe user service:" + this.username));
                    }
                    this.subscription.unsubscribe();
                }
                catch (Exception e) {
                    LOG.error((Object)("Thread interruption: Error while unsubscribe to thread of user:" + this.username));
                }
            }
            try {
                this.integrationService.removeInstance();
            }
            catch (Throwable e) {
                LOG.error((Object)"Error while inerrupting thread", e);
            }
            super.interrupt();
        }
    }
}

