/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class CalendarCreateUpdateAction
implements Action {
    public static final ThreadLocal<Boolean> IGNORE_UPDATE = new ThreadLocal();
    private static final Log LOG = ExoLogger.getLogger(CalendarCreateUpdateAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws Exception {
        Property property;
        if (IGNORE_UPDATE.get() != null && IGNORE_UPDATE.get().booleanValue()) {
            return false;
        }
        Object object = context.get((Object)"currentItem");
        Node node = null;
        if (object instanceof Node) {
            node = (Node)object;
        } else if (object instanceof Property && !this.isNotLastPropertyToSet(node = (property = (Property)object).getParent(), property)) {
            return false;
        }
        if (node != null && node.isNodeType("exo:calendarEvent") && this.isNodeValid(node)) {
            String eventId = node.getName();
            try {
                String userId = null;
                ConversationState state = ConversationState.getCurrent();
                userId = state == null || state.getIdentity() == null || state.getIdentity().getUserId().equals(IdentityConstants.ANONIM) ? node.getNode("../../../../..").getName() : state.getIdentity().getUserId();
                if (userId == null) {
                    LOG.warn((Object)("No user was found while trying to create/update eXo Calendar event with id: " + eventId));
                    return false;
                }
                IntegrationService integrationService = IntegrationService.getInstance(userId);
                if (integrationService == null) {
                    LOG.warn((Object)("No authenticated user was found while trying to create/update eXo Calendar event with id: '" + eventId + "' for user: " + userId));
                    return false;
                }
                boolean started = false;
                try {
                    String calendarId = node.getProperty("exo:calendarId").getString();
                    if (integrationService.isCalendarSynchronizedWithExchange(calendarId) && !integrationService.isSynchronizationStarted()) {
                        integrationService.setSynchronizationStarted();
                        started = true;
                        if (integrationService.getUserExoLastCheckDate() != null) {
                            integrationService.updateOrCreateExchangeCalendarEvent(node);
                            this.modifyUpdateDate(node);
                            integrationService.setUserExoLastCheckDate(com.ibm.icu.util.Calendar.getInstance().getTime().getTime());
                        }
                        integrationService.setSynchronizationStopped();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while create/update an Exchange item for eXo event: " + eventId), (Throwable)e);
                    integrationService.setUserExoLastCheckDate(0L);
                }
                finally {
                    if (started) {
                        integrationService.setSynchronizationStopped();
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating Exchange with the eXo Event with Id: " + eventId), (Throwable)e);
            }
        }
        return false;
    }

    private void modifyUpdateDate(Node node) throws Exception {
        if (!node.isNodeType("exo:datetime")) {
            if (node.canAddMixin("exo:datetime")) {
                node.addMixin("exo:datetime");
            }
            node.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
        }
        node.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
    }

    private boolean isNotLastPropertyToSet(Node node, Property property) throws Exception {
        return property.getName().equals("exo:participantStatus") && (!node.isNodeType("exo:repeatCalendarEvent") || node.hasProperty("exo:repeat") && node.getProperty("exo:repeat").getString().equals(CalendarEvent.RP_NOREPEAT));
    }

    private boolean isNodeValid(Node node) throws Exception {
        return node.hasProperty("exo:participantStatus") && !node.isNodeType("exo:repeatCalendarEvent") || node.isNodeType("exo:repeatCalendarEvent") && node.hasProperty("exo:repeatInterval");
    }
}

