/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import com.ibm.icu.util.Calendar;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class CalendarDeleteAction
implements Action {
    private static final Log LOG = ExoLogger.getLogger(CalendarDeleteAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws Exception {
        Node node = (Node)context.get((Object)"currentItem");
        if (node.isNodeType("exo:calendarEvent")) {
            String eventId = node.getName();
            try {
                String userId = null;
                ConversationState state = ConversationState.getCurrent();
                userId = state == null || state.getIdentity() == null || state.getIdentity().getUserId().equals(IdentityConstants.ANONIM) ? node.getNode("../../../../..").getName() : state.getIdentity().getUserId();
                IntegrationService integrationService = IntegrationService.getInstance(userId);
                if (integrationService == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.info((Object)("User '" + state.getIdentity().getUserId() + "' has no Exchange service, event will not be deleted from Exchange: eventId=" + eventId));
                    }
                    return false;
                }
                boolean started = false;
                try {
                    String calendarId = node.getProperty("exo:calendarId").getString();
                    if (integrationService.isCalendarSynchronizedWithExchange(calendarId) && !integrationService.isSynchronizationStarted()) {
                        integrationService.setSynchronizationStarted();
                        started = true;
                        if (integrationService.getUserExoLastCheckDate() != null) {
                            integrationService.deleteExchangeCalendarEvent(eventId, calendarId);
                            integrationService.setUserExoLastCheckDate(Calendar.getInstance().getTime().getTime());
                        }
                        integrationService.setSynchronizationStopped();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while deleting Exchange event: " + eventId), (Throwable)e);
                    integrationService.setUserExoLastCheckDate(0L);
                }
                finally {
                    if (started) {
                        integrationService.setSynchronizationStopped();
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while deleting Exchange item corresponding event to eXo Event with Id: " + eventId), (Throwable)e);
            }
        }
        return false;
    }
}

