/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.extension.exchange.listener.ExchangeIntegrationTask;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.ExchangeStorageService;
import org.exoplatform.extension.exchange.service.ExoStorageService;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;

public class IntegrationListener
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(IntegrationListener.class);
    private static final String EXCHANGE_SERVER_URL_PARAM_NAME = "exchange.ews.url";
    private static final String EXCHANGE_DOMAIN_PARAM_NAME = "exchange.domain";
    private static final String EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME = "exchange.scheduler.delay";
    private static final int EXCHANGE_LISTENER_SCHEDULER_DELAY_MINIMUM = 5;
    private static final String EXCHANGE_SYNCHRONIZE_ALL = "exchange.synchronize.all.folders";
    private static final String EXCHANGE_DELETE_CALENDAR_ON_UNSYNC = "exchange.delete.calendar.on.unsync";
    private int schedulerDelayInSeconds = 5;
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<String, ScheduledFuture<?>> futures = new HashMap();
    private final Map<String, Runnable> runnables = new HashMap<String, Runnable>();
    private final ExoStorageService exoStorageService;
    private final ExchangeStorageService exchangeStorageService;
    private final CorrespondenceService correspondenceService;
    private final OrganizationService organizationService;
    private final CalendarService calendarService;
    private final IdentityRegistry identityRegistry;
    private String exchangeServerURL;
    private String exchangeDomain;
    private boolean synchronizeAllExchangeFolders = false;
    private boolean deleteExoCalendarOnUnsync = false;

    public IntegrationListener(OrganizationService organizationService, CalendarService calendarService, ExoStorageService exoStorageService, ExchangeStorageService exchangeStorageService, CorrespondenceService correspondenceService, IdentityRegistry identityRegistry, InitParams params) {
        String exchangeSynchronizeAllString;
        String deleteExoCalendarOnUnsyncString;
        this.exoStorageService = exoStorageService;
        this.exchangeStorageService = exchangeStorageService;
        this.correspondenceService = correspondenceService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
        this.calendarService = calendarService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ExchangeSynchronization-%d").build();
        this.scheduledExecutor = Executors.newScheduledThreadPool(10, namedThreadFactory);
        if (params.containsKey((Object)EXCHANGE_SERVER_URL_PARAM_NAME) && !params.getValueParam(EXCHANGE_SERVER_URL_PARAM_NAME).getValue().isEmpty()) {
            this.exchangeServerURL = params.getValueParam(EXCHANGE_SERVER_URL_PARAM_NAME).getValue();
        } else {
            LOG.warn((Object)"Echange Synchronization Service: Default MS Exchange server URL (init-param exchange.ews.url) is not set.");
        }
        if (params.containsKey((Object)EXCHANGE_DOMAIN_PARAM_NAME) && !params.getValueParam(EXCHANGE_DOMAIN_PARAM_NAME).getValue().isEmpty()) {
            this.exchangeDomain = params.getValueParam(EXCHANGE_DOMAIN_PARAM_NAME).getValue();
        } else {
            LOG.warn((Object)"Echange Synchronization Service: Default MS Exchange domain name (init-param exchange.domain) is not set.");
        }
        if (params.containsKey((Object)EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME)) {
            String schedulerDelayInSecondsString = params.getValueParam(EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME).getValue();
            this.schedulerDelayInSeconds = Integer.valueOf(schedulerDelayInSecondsString);
        } else {
            LOG.warn("Echange Synchronization Service: Check Period in seconds (init-param {}) is not set. Default will be used: {} seconds.", new Object[]{EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME, 5});
            this.schedulerDelayInSeconds = 5;
        }
        if (this.schedulerDelayInSeconds < 5) {
            LOG.warn("Echange Synchronization Service: Check Period in seconds (init-param {}) is set under {} seconds. Default will be used: {} seconds.", new Object[]{EXCHANGE_LISTENER_SCHEDULER_DELAY_NAME, 5, 5});
            this.schedulerDelayInSeconds = 5;
        }
        if (params.containsKey((Object)EXCHANGE_DELETE_CALENDAR_ON_UNSYNC) && (deleteExoCalendarOnUnsyncString = params.getValueParam(EXCHANGE_DELETE_CALENDAR_ON_UNSYNC).getValue()) != null && deleteExoCalendarOnUnsyncString.equals("true")) {
            this.deleteExoCalendarOnUnsync = true;
        }
        if (params.containsKey((Object)EXCHANGE_SYNCHRONIZE_ALL) && (exchangeSynchronizeAllString = params.getValueParam(EXCHANGE_SYNCHRONIZE_ALL).getValue()) != null && exchangeSynchronizeAllString.equals("true")) {
            this.synchronizeAllExchangeFolders = true;
        }
    }

    public void start() {
        LOG.info((Object)"Echange Synchronization Service: Successfully started.");
    }

    public void stop() {
        this.scheduledExecutor.shutdownNow();
    }

    public String getExchangeDomain() {
        return this.exchangeDomain;
    }

    public String getExchangeServerURL() {
        return this.exchangeServerURL;
    }

    public void userLoggedIn(String username, String password) throws Exception {
        String exchangeStoredUsername = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.username");
        if (StringUtils.isNotBlank((String)exchangeStoredUsername)) {
            String exchangeStoredServerName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.url");
            String exchangeStoredDomainName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.domain");
            String exchangeStoredPassword = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.password");
            this.startExchangeSynchronizationTask(username, exchangeStoredUsername, exchangeStoredPassword, exchangeStoredDomainName, exchangeStoredServerName);
        } else if (StringUtils.isNotBlank((String)this.exchangeDomain) && StringUtils.isNotBlank((String)this.exchangeServerURL)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Exchange Synchronization Service: User '" + username + "' have not yet set parameters, use default Exchange server settings."));
            }
            this.startExchangeSynchronizationTask(username, username, password, this.exchangeDomain, this.exchangeServerURL);
        } else {
            LOG.warn((Object)"Exchange Service is unvailable, please set parameters.");
        }
    }

    public void startExchangeSynchronizationTask(String username, String exchangeUsername, String password, String exchangeDomain, String exchangeServerURL) {
        block3: {
            try {
                exchangeUsername = exchangeUsername.trim();
                Identity identity = this.identityRegistry.getIdentity(username);
                if (identity == null || identity.getUserId().equals(IdentityConstants.ANONIM)) {
                    throw new IllegalStateException("Identity of user '" + username + "' not found.");
                }
                this.closeTaskIfExists(username);
                ExchangeIntegrationTask schedulerCommand = new ExchangeIntegrationTask(this.organizationService, this.calendarService, this.exoStorageService, this.exchangeStorageService, this.correspondenceService, identity, exchangeUsername, password, exchangeDomain, exchangeServerURL, this.synchronizeAllExchangeFolders, this.deleteExoCalendarOnUnsync);
                ScheduledFuture<?> future = this.scheduledExecutor.scheduleWithFixedDelay(schedulerCommand, 10L, this.schedulerDelayInSeconds, TimeUnit.SECONDS);
                this.futures.put(username, future);
                this.runnables.put(username, schedulerCommand);
                LOG.info((Object)("User '" + username + "' logged in, exchange synchronization task started."));
            }
            catch (Exception e) {
                LOG.warn((Object)("Exchange integration error for user '" + username + "' : "), (Throwable)e);
                if (!LOG.isTraceEnabled() && !LOG.isDebugEnabled()) break block3;
                LOG.trace((Object)"Error while initializing user integration with exchange: ", (Throwable)e);
            }
        }
    }

    public void userLoggedOut(String username) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)CommonsUtils.getService(ConversationRegistry.class);
        List stateKeys = conversationRegistry.getStateKeys(username);
        if (stateKeys == null || stateKeys.isEmpty()) {
            this.closeTaskIfExists(username);
        }
    }

    public void synchronize(String username) {
        Runnable command = this.runnables.get(username);
        if (command != null) {
            command.run();
        }
    }

    private void closeTaskIfExists(String username) {
        ScheduledFuture<?> future = this.futures.remove(username);
        if (future != null) {
            future.cancel(true);
            IntegrationService integrationService = IntegrationService.getInstance(username);
            if (integrationService != null) {
                try {
                    integrationService.removeInstance();
                }
                catch (Throwable e) {
                    LOG.error((Object)e);
                }
            }
            LOG.info((Object)("Exchange synchronization task stopped for User '" + username + "'."));
        }
    }
}

