/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import org.exoplatform.extension.exchange.listener.IntegrationListener;
import org.exoplatform.extension.exchange.model.FolderBean;
import org.exoplatform.extension.exchange.model.UserSettings;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/exchange")
public class ExchangeRESTService
implements ResourceContainer,
Serializable {
    private static final long serialVersionUID = -8085801604143848875L;
    private static final Log LOG = ExoLogger.getLogger(ExchangeRESTService.class);
    static CacheControl cc = new CacheControl();
    private transient IntegrationListener integrationListener;
    private transient OrganizationService organizationService;

    public ExchangeRESTService(IntegrationListener integrationListener, OrganizationService organizationService) {
        this.integrationListener = integrationListener;
        this.organizationService = organizationService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars")
    @Produces(value={"application/json"})
    public Response getCalendars() throws Exception {
        String username = this.getCurrentUser();
        try {
            ArrayList<FolderBean> beans = new ArrayList<FolderBean>();
            IntegrationService service = IntegrationService.getInstance(username);
            if (service != null) {
                List<FolderId> folderIDs = service.getAllExchangeCalendars();
                for (FolderId folderId : folderIDs) {
                    CalendarFolder folder = service.getExchangeCalendar(folderId);
                    if (folder == null) continue;
                    boolean synchronizedFolder = service.isCalendarSynchronizedWithExchange(folderId.getUniqueId());
                    FolderBean bean = new FolderBean(folderId.getUniqueId(), folder.getDisplayName(), synchronizedFolder);
                    beans.add(bean);
                }
            }
            return Response.ok(beans).cacheControl(cc).build();
        }
        catch (Exception e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Exchange Inegration Service: Unable to retrieve list of calendars for user: '" + username + "'"));
            }
            return Response.ok().cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/syncNow")
    public Response synchronizeNow() {
        try {
            String username = this.getCurrentUser();
            this.integrationListener.synchronize(username);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while synchronizing manually the calendars", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/sync")
    public Response synchronizeFolderWithExo(@QueryParam(value="folderId") String folderIdString) throws Exception {
        if (folderIdString == null || folderIdString.isEmpty()) {
            LOG.warn((Object)"folderId parameter is null while synchronizing.");
            return Response.noContent().build();
        }
        String username = this.getCurrentUser();
        IntegrationService service = IntegrationService.getInstance(username);
        service.addFolderToSynchronization(folderIdString);
        this.integrationListener.synchronize(username);
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/unsync")
    public Response unsynchronizeFolderWithExo(@QueryParam(value="folderId") String folderIdString) throws Exception {
        if (folderIdString == null || folderIdString.isEmpty()) {
            LOG.warn((Object)"folderId parameter is null while unsynchronizing");
            return Response.noContent().build();
        }
        String username = this.getCurrentUser();
        IntegrationService service = IntegrationService.getInstance(username);
        service.deleteFolderFromSynchronization(folderIdString);
        this.integrationListener.synchronize(username);
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/settings")
    @Produces(value={"application/json"})
    public Response getSettings() throws Exception {
        try {
            String username = this.getCurrentUser();
            UserSettings settings = new UserSettings();
            String exchangeServerName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.url");
            String exchangeDomainName = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.server.domain");
            String exchangeUsername = IntegrationService.getUserArrtibute(this.organizationService, username, "exchange.username");
            settings.setServerName(exchangeServerName == null ? this.integrationListener.getExchangeServerURL() : exchangeServerName);
            settings.setDomainName(exchangeDomainName == null ? this.integrationListener.getExchangeDomain() : exchangeDomainName);
            settings.setUsername(exchangeUsername == null ? username : exchangeUsername);
            return Response.ok((Object)settings, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/settings")
    @Consumes(value={"application/json"})
    public Response setSettings(UserSettings settings) throws Exception {
        try {
            String username = this.getCurrentUser();
            IntegrationService.setUserArrtibute(this.organizationService, username, "exchange.server.url", settings.getServerName());
            IntegrationService.setUserArrtibute(this.organizationService, username, "exchange.server.domain", settings.getDomainName());
            IntegrationService.setUserArrtibute(this.organizationService, username, "exchange.username", settings.getUsername());
            IntegrationService.setUserArrtibute(this.organizationService, username, "exchange.password", settings.getPassword());
            this.integrationListener.userLoggedOut(username);
            this.integrationListener.startExchangeSynchronizationTask(username, settings.getUsername(), settings.getPassword(), settings.getDomainName(), settings.getServerName());
            return Response.ok().cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    private String getCurrentUser() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

