/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;

public class BoxProvider
extends CloudProvider {
    protected final String authURL;
    protected final String redirectURL;
    protected final boolean loginSSO;
    protected final RepositoryService jcrService;

    public BoxProvider(String id, String name, String authURL, String redirectURL, boolean loginSSO, RepositoryService jcrService) {
        super(id, name);
        this.authURL = authURL;
        this.redirectURL = redirectURL;
        this.loginSSO = loginSSO;
        this.jcrService = jcrService;
    }

    public String getAuthURL() throws CloudDriveException {
        if (this.jcrService != null) {
            try {
                String currentRepo = this.jcrService.getCurrentRepository().getConfiguration().getName();
                return this.authURL.replace("__no_state_set__", currentRepo);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException((Throwable)e);
            }
        }
        return this.authURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public boolean isLoginSSO() {
        return this.loginSSO;
    }

    public boolean retryOnProviderError() {
        return true;
    }
}

