/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis.rest;

import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.cmis.ContentReader;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.cmis.ecms.viewer.storage.DocumentNotFoundException;
import org.exoplatform.clouddrive.cmis.ecms.viewer.storage.PDFViewerStorage;
import org.exoplatform.clouddrive.features.CloudDriveFeatures;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/drive/cmis/content")
public class ContentService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ContentService.class);
    public static String SERVICE_PATH;
    protected final CloudDriveFeatures features;
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final PDFViewerStorage pdfStorage;

    public ContentService(CloudDriveService cloudDrives, CloudDriveFeatures features, PDFViewerStorage pdfStorage, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.features = features;
        this.pdfStorage = pdfStorage;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @GET
    @Path(value="/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    public Response get(@PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @QueryParam(value="contentId") String contentId) {
        if (workspace != null) {
            if (path != null) {
                path = this.normalizePath(path);
                if (contentId != null) {
                    try {
                        ContentReader content;
                        CloudDrive drive = this.cloudDrives.findDrive(workspace, path);
                        if (drive != null && (content = ((JCRLocalCMISDrive)drive).getFileContent(contentId)) != null) {
                            Response.ResponseBuilder resp = Response.ok().entity((Object)content.getStream());
                            long len = content.getLength();
                            if (len >= 0L) {
                                resp.header("Content-Length", (Object)len);
                            }
                            resp.type(content.getMimeType());
                            String typeMode = content.getTypeMode();
                            if (typeMode != null && typeMode.length() > 0) {
                                resp.header("x-type-mode", (Object)typeMode);
                            }
                            return resp.build();
                        }
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not CMIS file.").build();
                    }
                    catch (LoginException e) {
                        LOG.warn((Object)("Error login to read cloud file content " + workspace + ":" + path + ": " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                    }
                    catch (NotFoundException e) {
                        LOG.warn((Object)("File not found to read its content " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("File not found. " + e.getMessage())).build();
                    }
                    catch (CloudDriveException e) {
                        LOG.warn((Object)("Error reading file content " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading file content. " + e.getMessage())).build();
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error reading file content " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file content: storage error.").build();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error reading file content " + workspace + ":" + path), e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file content: runtime error.").build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null fileId.").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/pdf/page/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    public Response getPageImage(@PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @QueryParam(value="contentId") String contentId, @DefaultValue(value="1") @QueryParam(value="page") String strPage, @DefaultValue(value="0") @QueryParam(value="rotation") String strRotation, @DefaultValue(value="1.0") @QueryParam(value="scale") String strScale) {
        if (workspace != null) {
            if (path != null) {
                path = this.normalizePath(path);
                if (contentId != null) {
                    try {
                        CloudDrive drive = this.cloudDrives.findDrive(workspace, path);
                        if (drive != null) {
                            String repository = this.jcrService.getCurrentRepository().getConfiguration().getName();
                            PDFViewerStorage.PDFFile pdfFile = this.pdfStorage.getFile(repository, workspace, drive, contentId);
                            if (pdfFile != null) {
                                int page;
                                float rotation;
                                float scale;
                                try {
                                    scale = Float.parseFloat(strScale);
                                    if (scale > 3.0f) {
                                        scale = 3.0f;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    scale = 1.0f;
                                }
                                try {
                                    rotation = Float.parseFloat(strRotation);
                                }
                                catch (NumberFormatException e) {
                                    rotation = 0.0f;
                                }
                                int maximumOfPage = pdfFile.getNumberOfPages();
                                try {
                                    page = Integer.parseInt(strPage);
                                }
                                catch (NumberFormatException e) {
                                    page = 1;
                                }
                                if (page >= maximumOfPage) {
                                    page = maximumOfPage;
                                } else if (page < 1) {
                                    page = 1;
                                }
                                PDFViewerStorage.PDFFile.ImageFile image = pdfFile.getPageImage(page, rotation, scale);
                                return Response.ok((Object)image.getStream(), (String)image.getType()).header("Last-Modified", (Object)pdfFile.getLastModified()).header("Content-Length", (Object)image.getLength()).header("Content-Disposition", (Object)("inline; filename=\"" + image.getName() + "\"")).build();
                            }
                            LOG.warn((Object)("PDF representation not available for " + workspace + ":" + path + " id:" + contentId));
                            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                        }
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not CMIS file.").build();
                    }
                    catch (DocumentNotFoundException e) {
                        LOG.error((Object)("Error reading cloud file representation " + workspace + ":" + path + ": " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Cloud file representation not found.").build();
                    }
                    catch (LoginException e) {
                        LOG.warn((Object)("Error login to read cloud file representation " + workspace + ":" + path + ": " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                    }
                    catch (CloudDriveException e) {
                        LOG.warn((Object)("Error reading cloud file representation " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading cloud file representation. " + e.getMessage())).build();
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error reading cloud file representation " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading cloud file representation: storage error.").build();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error reading file content " + workspace + ":" + path), e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading cloud file representation: runtime error.").build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null fileId.").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/pdf/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    public Response getPDF(@PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @QueryParam(value="contentId") String contentId) {
        if (workspace != null) {
            if (path != null) {
                path = this.normalizePath(path);
                if (contentId != null) {
                    try {
                        CloudDrive drive = this.cloudDrives.findDrive(workspace, path);
                        if (drive != null) {
                            String repository = this.jcrService.getCurrentRepository().getConfiguration().getName();
                            PDFViewerStorage.PDFFile pdfFile = this.pdfStorage.getFile(repository, workspace, drive, contentId);
                            if (pdfFile != null) {
                                Response.ResponseBuilder resp = Response.ok((Object)pdfFile.getStream(), (String)pdfFile.getMimeType()).header("Last-Modified", (Object)pdfFile.getLastModified()).header("Content-Length", (Object)pdfFile.getLength());
                                resp.header("Content-Disposition", (Object)("attachment; filename=\"" + pdfFile.getName() + "\""));
                                return resp.build();
                            }
                            LOG.warn((Object)("PDF representation not available for " + workspace + ":" + path + " id:" + contentId));
                            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                        }
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not CMIS file.").build();
                    }
                    catch (DocumentNotFoundException e) {
                        LOG.error((Object)("Error reading cloud file PDF representation " + workspace + ":" + path + ": " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Cloud file PDF representation not found.").build();
                    }
                    catch (LoginException e) {
                        LOG.warn((Object)("Error login to read cloud file PDF representation " + workspace + ":" + path + ": " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                    }
                    catch (CloudDriveException e) {
                        LOG.warn((Object)("Error reading cloud file PDF representation " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading cloud file PDF representation. " + e.getMessage())).build();
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error reading cloud file representation " + workspace + ":" + path), (Throwable)e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading cloud file PDF representation: storage error.").build();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error reading file content " + workspace + ":" + path), e);
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading cloud file PDF representation: runtime error.").build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null fileId.").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    protected String normalizePath(String path) {
        return path.length() > 0 && path.endsWith("/") ? "/" + path.substring(0, path.length() - 1) : "/" + path;
    }

    static {
        Path restPath = ContentService.class.getAnnotation(Path.class);
        SERVICE_PATH = restPath.value();
    }
}

