/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveServiceImpl;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISConnectorImpl;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISProvider;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.cmis.login.AuthenticationException;
import org.exoplatform.clouddrive.cmis.login.CodeAuthentication;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class CMISConnector
extends CloudDriveConnector {
    protected static final String CONFIG_PREDEFINED = "";
    private final CodeAuthentication codeAuth;
    private final ConcurrentHashMap<String, AuthFlow> users = new ConcurrentHashMap();

    public CMISConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params, CodeAuthentication codeAuth) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
        this.codeAuth = codeAuth;
    }

    protected CMISProvider getProvider() {
        return (CMISProvider)super.getProvider();
    }

    protected CloudProvider createProvider() throws ConfigurationException {
        StringBuilder redirectURL = new StringBuilder();
        redirectURL.append(this.getConnectorSchema());
        redirectURL.append("://");
        redirectURL.append(this.getConnectorHost());
        redirectURL.append('/');
        redirectURL.append(PortalContainer.getCurrentPortalContainerName());
        redirectURL.append('/');
        redirectURL.append(PortalContainer.getCurrentRestContextName());
        redirectURL.append("/clouddrive/connect/");
        redirectURL.append(this.getProviderId());
        StringBuilder authURL = new StringBuilder();
        authURL.append(this.getConnectorSchema());
        authURL.append("://");
        authURL.append(this.getConnectorHost());
        authURL.append('/');
        authURL.append(PortalContainer.getCurrentPortalContainerName());
        authURL.append("/clouddrive/");
        authURL.append(this.getAuthProviderId());
        authURL.append("/login?state=");
        try {
            authURL.append(URLEncoder.encode("__no_state_set__", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode state __no_state_set__:" + e));
            authURL.append("__no_state_set__");
        }
        authURL.append("&providerId=");
        authURL.append(this.getProviderId());
        authURL.append("&redirect_uri=");
        try {
            authURL.append(URLEncoder.encode(redirectURL.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode redirect URL " + redirectURL.toString() + ":" + e));
            authURL.append((CharSequence)redirectURL);
        }
        CMISProvider provider = new CMISProvider(this.getProviderId(), this.getProviderName(), authURL.toString(), this.jcrService);
        provider.initPredefined(this.predefinedServices.getServices());
        return provider;
    }

    protected CMISUser authenticate(String code) throws CloudDriveException {
        if (code != null && code.length() > 0) {
            AuthFlow userFlow = this.users.remove(code);
            if (userFlow == null) {
                try {
                    CodeAuthentication.Identity userId = this.codeAuth.exchangeCode(code);
                    CMISUser user = this.createUser(userId);
                    this.users.put(code, new AuthFlow(user, userId));
                    return user;
                }
                catch (AuthenticationException e) {
                    throw new CloudDriveException("Authentication failed: " + e.getMessage(), (Throwable)e);
                }
            }
            CMISUser user = userFlow.user;
            CodeAuthentication.Identity userId = userFlow.identity;
            String context = userId.getServiceContext();
            if (context != null) {
                user.setRepositoryId(context);
                RepositoryInfo repo = user.api().getRepositoryInfo();
                CloudDriveServiceImpl cdService = (CloudDriveServiceImpl)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CloudDriveServiceImpl.class);
                for (CloudDriveConnector cdc : cdService.getConnectors()) {
                    CMISConnectorImpl cimpl;
                    if (!(cdc instanceof CMISConnectorImpl) || !(cimpl = (CMISConnectorImpl)cdc).hasSupport(repo)) continue;
                    CMISConnector c = cimpl.getConnector();
                    if (c == this) break;
                    user = c.createUser(userId);
                    user.setRepositoryId(context);
                    break;
                }
                return user;
            }
            throw new CloudDriveException("CMIS repository not defined");
        }
        throw new CloudDriveException("Access code should not be null or empty");
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof CMISUser) {
            CMISUser apiUser = (CMISUser)user;
            JCRLocalCMISDrive drive = new JCRLocalCMISDrive(apiUser, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes, this.exoURL());
            return drive;
        }
        throw new CloudDriveException("Not cloud user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        JCRLocalCMISDrive drive = new JCRLocalCMISDrive(new API(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes, this.exoURL());
        return drive;
    }

    protected String exoURL() {
        StringBuilder exoURL = new StringBuilder();
        exoURL.append(this.getConnectorSchema());
        exoURL.append("://");
        exoURL.append(this.getConnectorHost());
        return exoURL.toString();
    }

    protected CMISAPI createAPI(CodeAuthentication.Identity userId) throws CMISException, CloudDriveException {
        return new API().auth(userId.getUser(), userId.getPassword()).serviceUrl(userId.getServiceURL()).build();
    }

    protected CMISUser createUser(CodeAuthentication.Identity userId) throws CMISException, CloudDriveException {
        CMISAPI api = this.createAPI(userId);
        return new CMISUser(api.getUser(), api.getUser(), CONFIG_PREDEFINED, this.provider, api);
    }

    protected String getAuthProviderId() throws ConfigurationException {
        return this.getProviderId();
    }

    class AuthFlow {
        final CMISUser user;
        final CodeAuthentication.Identity identity;

        AuthFlow(CMISUser user, CodeAuthentication.Identity identity) {
            this.user = user;
            this.identity = identity;
        }
    }

    protected class API {
        protected String serviceUrl;
        protected String user;
        protected String password;

        protected API() {
        }

        protected API auth(String user, String password) {
            this.user = user;
            this.password = password;
            return this;
        }

        protected API serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        protected CMISAPI build() throws CMISException, CloudDriveException {
            if (this.user == null || this.password == null) {
                throw new CloudDriveException("Cannot create API: user required");
            }
            if (this.serviceUrl == null) {
                throw new CloudDriveException("Cannot create API: service URL required");
            }
            return new CMISAPI(this.serviceUrl, this.user, this.password);
        }

        protected CMISUser createUser(String userId, String userName, String email, CMISAPI api) {
            return new CMISUser(userId, userName, email, CMISConnector.this.getProvider(), api);
        }
    }
}

