/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.DbxAccountInfo;
import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.DbxWebAuth;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotApprovedException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.dropbox.DropboxAPI;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.DropboxProvider;
import org.exoplatform.clouddrive.dropbox.DropboxUser;
import org.exoplatform.clouddrive.dropbox.JCRLocalDropboxDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.organization.OrganizationService;

public class DropboxConnector
extends CloudDriveConnector {
    protected final OrganizationService organization;
    protected API apiBuilder;

    public DropboxConnector(RepositoryService jcrService, SessionProviderService sessionProviders, OrganizationService organization, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
        this.organization = organization;
    }

    protected DropboxProvider getProvider() {
        return (DropboxProvider)super.getProvider();
    }

    protected CloudProvider createProvider() throws ConfigurationException {
        if (this.apiBuilder == null) {
            this.apiBuilder = new API();
        }
        String redirectURL = this.redirectLink();
        this.apiBuilder.redirectUri(redirectURL.toString());
        return new DropboxProvider(this.getProviderId(), this.getProviderName(), this.apiBuilder, redirectURL, this.jcrService);
    }

    protected CloudUser authenticate(Map<String, String> params) throws CloudDriveException {
        String code = params.get("code");
        if (code != null && code.length() > 0) {
            DropboxAPI driveAPI = this.apiBuilder.auth(params).build();
            DbxAccountInfo apiUser = driveAPI.getCurrentUser();
            String userId = String.valueOf(apiUser.userId);
            String asEmail = "<" + apiUser.displayName + ">" + userId + "@dropbox";
            DropboxUser user = new DropboxUser(userId, apiUser.displayName, asEmail, this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access key should not be null or empty");
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof DropboxUser) {
            DropboxUser apiUser = (DropboxUser)user;
            JCRLocalDropboxDrive drive = new JCRLocalDropboxDrive(apiUser, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
            return drive;
        }
        throw new CloudDriveException("Not cloud user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        JCRLocalDropboxDrive drive = new JCRLocalDropboxDrive(this.apiBuilder, this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
        return drive;
    }

    class API {
        final DbxAppInfo appInfo;
        final DbxRequestConfig authConfig;
        String redirectUri;
        String accessToken;
        Map<String, DbxWebAuth> auths;
        Map<String, String> authLinks;
        Map<String, String[]> params;

        API() {
            this.appInfo = new DbxAppInfo(DropboxConnector.this.getClientId(), DropboxConnector.this.getClientSecret());
            this.authConfig = new DbxRequestConfig("eXo Cloud Drive Client", Locale.getDefault().toString());
            this.auths = new HashMap<String, DbxWebAuth>();
            this.authLinks = new HashMap<String, String>();
        }

        private synchronized DbxWebAuth init(String user) {
            DbxWebAuth auth = this.auths.get(user);
            if (auth == null) {
                auth = new DbxWebAuth(this.authConfig, this.appInfo, this.redirectUri, (DbxSessionStore)new AuthSessionStore());
                this.auths.put(user, auth);
            }
            return auth;
        }

        private synchronized DbxWebAuth finish(String user) {
            return this.auths.remove(user);
        }

        API redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        String authLink(String state) {
            String user = DropboxConnector.this.currentUser();
            String link = this.authLinks.get(user);
            if (link == null) {
                DbxWebAuth auth = this.init(user);
                link = auth.start(state);
                this.authLinks.put(user, link);
            }
            return link;
        }

        API auth(Map<String, String> params) {
            HashMap<String, String[]> dbxParams = new HashMap<String, String[]>();
            for (Map.Entry<String, String> pe : params.entrySet()) {
                dbxParams.put(pe.getKey(), new String[]{pe.getValue()});
            }
            this.params = dbxParams;
            this.authLinks.remove(DropboxConnector.this.currentUser());
            return this;
        }

        API load(String accessToken) {
            this.init(DropboxConnector.this.currentUser());
            this.accessToken = accessToken;
            return this;
        }

        DropboxAPI build() throws DropboxException, CloudDriveException {
            String user = DropboxConnector.this.currentUser();
            if (this.params != null && this.params.size() > 0) {
                try {
                    DbxWebAuth auth = this.finish(user);
                    if (auth != null) {
                        DbxAuthFinish authFinish = auth.finish(this.params);
                        return new DropboxAPI(this.authConfig, authFinish.accessToken);
                    }
                    throw new CloudDriveException("API not properly initialized for user " + user);
                }
                catch (DbxWebAuth.BadRequestException e) {
                    String msg = "Wrong authorization parameter(s)";
                    LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new DropboxException(msg);
                }
                catch (DbxWebAuth.BadStateException e) {
                    String msg = "Authorization session expired";
                    LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new CloudDriveAccessException(msg + ". Please try again later.");
                }
                catch (DbxWebAuth.CsrfException e) {
                    String msg = "Authorization state not found";
                    LOG.warn((Object)(msg + ". CSRF error during authorization: " + e.getMessage()), (Throwable)e);
                    throw new DropboxException(msg + ". Please retry your request.");
                }
                catch (DbxWebAuth.NotApprovedException e) {
                    String msg = "Access not approved";
                    LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new NotApprovedException(msg);
                }
                catch (DbxWebAuth.ProviderException e) {
                    String msg = "Authorization process error";
                    LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new DropboxException(msg + ". Please retry your request.");
                }
                catch (DbxException.InvalidAccessToken e) {
                    String msg = "Invalid access credentials";
                    LOG.warn((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
                    throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
                }
                catch (DbxException.RetryLater e) {
                    String msg = "Dropbox overloaded or hit rate exceeded";
                    LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new DropboxException(msg + ". Please try again later.");
                }
                catch (DbxException e) {
                    String msg = "Dropbox error";
                    LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                    throw new DropboxException(msg + ". Please try again later.");
                }
            }
            if (this.accessToken != null) {
                return new DropboxAPI(this.authConfig, this.accessToken);
            }
            throw new CloudDriveException("API not properly authorized nor loaded with ready access token for user " + user);
        }
    }

    class AuthSessionStore
    implements DbxSessionStore {
        final AtomicReference<String> state = new AtomicReference();

        AuthSessionStore() {
        }

        public String get() {
            return this.state.get();
        }

        public void set(String value) {
            this.state.set(value);
        }

        public void clear() {
            this.state.set(null);
        }
    }
}

