/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.gdrive;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.Change;
import com.google.api.services.drive.model.ChildReference;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.ParentReference;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.gdrive.GoogleDriveAPI;
import org.exoplatform.clouddrive.gdrive.GoogleDriveConnector;
import org.exoplatform.clouddrive.gdrive.GoogleDriveException;
import org.exoplatform.clouddrive.gdrive.GoogleProvider;
import org.exoplatform.clouddrive.gdrive.GoogleUser;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalGoogleDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    protected JCRLocalGoogleDrive(GoogleUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder);
        this.getUser().api().getToken().addListener(this);
    }

    protected JCRLocalGoogleDrive(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder) throws RepositoryException, GoogleDriveException, CloudDriveException {
        super((CloudUser)JCRLocalGoogleDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders, finder);
        this.getUser().api().getToken().addListener(this);
    }

    protected static GoogleUser loadUser(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode) throws RepositoryException, GoogleDriveException, CloudDriveException {
        String refreshToken;
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("gdrive:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("gdrive:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("gdrive:oauth2TokenExpirationTime").getLong();
        GoogleDriveAPI driveAPI = apiBuilder.load(userId, refreshToken, accessToken, expirationTime).build();
        return new GoogleUser(userId, username, email, provider, driveAPI);
    }

    public GoogleUser getUser() {
        return (GoogleUser)this.user;
    }

    public String getState() {
        return null;
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("gdrive:oauth2AccessToken", token.getAccessToken());
                driveNode.setProperty("gdrive:oauth2RefreshToken", token.getRefreshToken());
                driveNode.setProperty("gdrive:oauth2TokenExpirationTime", token.getExpirationTime());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected void refreshAccess() throws GoogleDriveException {
        this.getUser().api().refreshAccess();
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        block10: {
            this.getUser().api().updateToken(((GoogleUser)newUser).api().getToken());
            try {
                boolean updateScopes;
                Node driveNode = this.rootNode();
                try {
                    updateScopes = !GoogleDriveAPI.SCOPES_STRING.equals(driveNode.getProperty("gdrive:scopes").getString());
                }
                catch (PathNotFoundException e) {
                    updateScopes = true;
                }
                if (!updateScopes) break block10;
                this.jcrListener.disable();
                try {
                    driveNode.setProperty("gdrive:scopes", GoogleDriveAPI.SCOPES_STRING);
                    driveNode.save();
                }
                catch (RepositoryException e) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("Error updating access scopes: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    this.jcrListener.enable();
                }
            }
            catch (DriveRemovedException e) {
                throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isAccessScopeMatch() throws RepositoryException, DriveRemovedException {
        Node driveNode = this.rootNode();
        try {
            return GoogleDriveAPI.SCOPES_STRING.equals(driveNode.getProperty("gdrive:scopes").getString());
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected boolean checkAccessScope(CloudDriveAccessException cause) throws RepositoryException, RefreshAccessException, DriveRemovedException {
        if (cause != null && !this.isAccessScopeMatch()) {
            throw new RefreshAccessException("Renew access key to Google Drive", (Throwable)cause);
        }
        return false;
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("gdrive:largestChangeId").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title());
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("gdrive:largestChangeId", id.longValue());
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        About about = this.getUser().api().about();
        driveNode.setProperty("ecd:id", about.getRootFolderId());
        driveNode.setProperty("ecd:url", about.getSelfLink());
        driveNode.setProperty("gdrive:scopes", GoogleDriveAPI.SCOPES_STRING);
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new Sync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected List<ParentReference> mergeParents(String parentId, List<ParentReference> cloudParents, Collection<String> localParentIds) {
        ArrayList<ParentReference> parents = new ArrayList<ParentReference>();
        if (cloudParents != null && cloudParents.size() > 1) {
            for (ParentReference cp : cloudParents) {
                if (!localParentIds.contains(cp.getId())) continue;
                parents.add(cp);
            }
        }
        parents.add(new ParentReference().setId(parentId));
        return parents;
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final GoogleDriveAPI api;

        FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        public String createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setTitle(this.getTitle(fileNode));
            gf.setMimeType(mimeType);
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(fileNode))));
            gf.setCreatedDate(new DateTime(created.getTime()));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            InputStreamContent fileContent = new InputStreamContent(mimeType, content);
            try {
                gf = this.api.insert(gf, (AbstractInputStreamContent)fileContent);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
            return gf.getId();
        }

        public String createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setTitle(this.getTitle(folderNode));
            gf.setMimeType("application/vnd.google-apps.folder");
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(folderNode))));
            gf.setCreatedDate(new DateTime(created.getTime()));
            try {
                gf = this.api.insert(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            JCRLocalGoogleDrive.this.initFolder(folderNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
            return gf.getId();
        }

        public void updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            File gf = this.api.file(this.getId(fileNode));
            gf.setTitle(this.getTitle(fileNode));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            gf.setParents(JCRLocalGoogleDrive.this.mergeParents(this.getParentId(fileNode), gf.getParents(), this.findParents(fileNode)));
            try {
                this.api.update(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public void updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            File gf = this.api.file(this.getId(folderNode));
            gf.setTitle(this.getTitle(folderNode));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            gf.setParents(JCRLocalGoogleDrive.this.mergeParents(this.getParentId(folderNode), gf.getParents(), this.findParents(folderNode)));
            try {
                this.api.update(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public void updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            File gf = this.api.file(this.getId(fileNode));
            gf.setMimeType(mimeType);
            gf.setModifiedDate(new DateTime(modified.getTime()));
            InputStreamContent fileContent = new InputStreamContent(mimeType, content);
            try {
                this.api.update(gf, (AbstractInputStreamContent)fileContent);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public String copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setId(this.getId(srcFileNode));
            gf.setTitle(this.getTitle(destFileNode));
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(destFileNode))));
            try {
                gf = this.api.copy(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
            Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            JCRLocalGoogleDrive.this.initFile(destFileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
            return gf.getId();
        }

        public String copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setId(this.getId(srcFolderNode));
            gf.setTitle(this.getTitle(destFolderNode));
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(destFolderNode))));
            try {
                gf = this.api.copy(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
            Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            JCRLocalGoogleDrive.this.initFolder(destFolderNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
            return gf.getId();
        }

        public void removeFile(String id) throws CloudDriveException, RepositoryException {
            try {
                this.api.delete(id);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public void removeFolder(String id) throws CloudDriveException, RepositoryException {
            try {
                this.api.delete(id);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.trash(id);
                return file.getLabels().getTrashed();
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.trash(id);
                return file.getLabels().getTrashed();
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.untrash(this.getId(fileNode));
                return file.getLabels().getTrashed() == false;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.untrash(this.getId(folderNode));
                return file.getLabels().getTrashed() == false;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean isTrashSupported() {
            return true;
        }
    }

    protected class Sync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final GoogleDriveAPI api;
        protected final Set<Node> synced;
        protected GoogleDriveAPI.ChangesIterator changes;

        protected Sync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.synced = new HashSet<Node>();
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        protected void syncFiles() throws RepositoryException, CloudDriveException {
            long largestChangeId;
            try {
                About about = this.api.about();
                largestChangeId = about.getLargestChangeId();
            }
            catch (CloudDriveAccessException e) {
                if (!JCRLocalGoogleDrive.this.isAccessScopeMatch()) {
                    throw new RefreshAccessException("Renew access key to Google Drive", (Throwable)e);
                }
                throw e;
            }
            long localChangeId = JCRLocalGoogleDrive.this.getChangeId();
            if (largestChangeId == localChangeId) {
                return;
            }
            long startChangeId = localChangeId + 1L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Synchronizing changes from " + startChangeId + " to about " + largestChangeId));
            }
            this.changes = this.api.changes(startChangeId);
            this.iterators.add(this.changes);
            if (this.changes.hasNext()) {
                this.readLocalNodes();
                this.syncNext();
            }
            JCRLocalGoogleDrive.this.setChangeId(this.changes.getLargestChangeId());
        }

        protected void syncNext() throws RepositoryException, CloudDriveException {
            while (this.changes.hasNext() && !Thread.currentThread().isInterrupted()) {
                String[] parents;
                Change ch = (Change)this.changes.next();
                File gf = ch.getFile();
                if (ch.getDeleted().booleanValue() || (parents = this.getParents(gf)).length == 0) {
                    if (JCRLocalGoogleDrive.this.hasRemoved(ch.getFileId())) {
                        JCRLocalGoogleDrive.this.cleanRemoved(ch.getFileId());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(">> Returned file removal " + ch.getFileId()));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> File removal " + ch.getFileId()));
                    }
                    this.deleteFile(ch.getFileId());
                    continue;
                }
                if (gf.getLabels().getTrashed().booleanValue()) {
                    if (JCRLocalGoogleDrive.this.hasRemoved(gf.getId())) {
                        JCRLocalGoogleDrive.this.cleanRemoved(gf.getId());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)(">> Returned file trashing " + gf.getId() + " " + gf.getTitle()));
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> File trashing " + gf.getId() + " " + gf.getTitle()));
                    }
                    this.deleteFile(gf.getId());
                    continue;
                }
                if (JCRLocalGoogleDrive.this.hasUpdated(gf.getId())) {
                    JCRLocalGoogleDrive.this.cleanUpdated(gf.getId());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)(">> Returned file update " + gf.getId() + " " + gf.getTitle()));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> File update " + gf.getId() + " " + gf.getTitle()));
                }
                this.updateFile(gf, parents);
            }
        }

        protected void deleteFile(String fileId) throws RepositoryException {
            List existing = (List)this.nodes.get(fileId);
            if (existing != null) {
                for (Node en : existing) {
                    String enpath = en.getPath();
                    Iterator ecnliter = this.nodes.values().iterator();
                    while (ecnliter.hasNext()) {
                        List ecnl = (List)ecnliter.next();
                        if (ecnl == existing) continue;
                        Iterator ecniter = ecnl.iterator();
                        while (ecniter.hasNext()) {
                            Node ecn = (Node)ecniter.next();
                            if (!ecn.getPath().startsWith(enpath)) continue;
                            ecniter.remove();
                        }
                        if (ecnl.size() != 0) continue;
                        ecnliter.remove();
                    }
                    this.removed.add(en.getPath());
                    en.remove();
                }
                this.nodes.remove(fileId);
            }
        }

        protected void updateFile(File gf, String[] parentIds) throws CloudDriveException, RepositoryException {
            ArrayList<Node> existing = (ArrayList<Node>)this.nodes.get(gf.getId());
            boolean isFolder = this.api.isFolder(gf);
            for (String parentFileId : parentIds) {
                List fileParent = (List)this.nodes.get(parentFileId);
                if (fileParent == null) {
                    this.syncNext();
                    fileParent = (List)this.nodes.get(parentFileId);
                    if (fileParent == null) {
                        throw new CloudDriveException("Inconsistent changes: cannot find parent Node for '" + gf.getTitle() + "'");
                    }
                }
                for (Node fp : fileParent) {
                    Node localNode = null;
                    Node localNodeCopy = null;
                    if (existing == null) {
                        existing = new ArrayList<Node>();
                        this.nodes.put(gf.getId(), existing);
                    } else {
                        Iterator i$ = existing.iterator();
                        while (i$.hasNext()) {
                            Node n;
                            localNodeCopy = n = (Node)i$.next();
                            if (!n.getParent().isSame((Item)fp)) continue;
                            localNode = n;
                            break;
                        }
                    }
                    if (localNode == null) {
                        localNode = isFolder ? (localNodeCopy == null ? JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), fp) : JCRLocalGoogleDrive.this.copyNode(localNodeCopy, fp)) : JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), gf.getMimeType(), fp);
                        existing.add(localNode);
                    } else if (!localNode.getProperty("exo:title").getString().equals(gf.getTitle())) {
                        localNode = JCRLocalGoogleDrive.this.moveFile(gf.getId(), gf.getTitle(), localNode, fp);
                    }
                    Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                    if (isFolder) {
                        JCRLocalGoogleDrive.this.initFolder(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    } else {
                        JCRLocalGoogleDrive.this.initFile(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    }
                    this.changed.add(new JCRLocalCloudFile(localNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), JCRLocalGoogleDrive.this.editLink(gf.getAlternateLink()), gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), gf.getLastModifyingUserName(), (String)gf.getOwnerNames().get(0), created, modified, isFolder));
                    this.synced.add(localNode);
                }
            }
            if (existing != null) {
                Iterator niter = existing.iterator();
                while (niter.hasNext()) {
                    Node n = (Node)niter.next();
                    if (this.synced.contains(n)) continue;
                    this.removed.add(n.getPath());
                    niter.remove();
                    n.remove();
                }
            }
        }

        protected String[] getParents(File gfile) {
            List parents;
            if (gfile != null && (parents = gfile.getParents()) != null) {
                String[] parentIds = new String[parents.size()];
                for (int i = 0; i < parents.size(); ++i) {
                    parentIds[i] = ((ParentReference)parents.get(i)).getId();
                }
                return parentIds;
            }
            return new String[0];
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final GoogleDriveAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            About about = this.api.about();
            String id = about.getRootFolderId();
            this.fetchChilds(id, this.rootNode);
            JCRLocalGoogleDrive.this.setChangeId(about.getLargestChangeId());
        }

        protected void fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            GoogleDriveAPI.ChildIterator children = this.api.children(fileId);
            this.iterators.add(children);
            while (children.hasNext() && !Thread.currentThread().isInterrupted()) {
                Node localNode;
                ChildReference child = (ChildReference)children.next();
                File gf = this.api.file(child.getId());
                if (gf.getLabels().getTrashed().booleanValue()) continue;
                boolean isFolder = this.api.isFolder(gf);
                DateTime createDate = gf.getCreatedDate();
                if (createDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Created Date.");
                }
                Calendar created = this.api.parseDate(createDate.toStringRfc3339());
                DateTime modifiedDate = gf.getModifiedDate();
                if (modifiedDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Modified Date.");
                }
                Calendar modified = this.api.parseDate(modifiedDate.toStringRfc3339());
                if (isFolder) {
                    localNode = JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), parent);
                    JCRLocalGoogleDrive.this.initFolder(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    this.fetchChilds(gf.getId(), localNode);
                } else {
                    localNode = JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), gf.getMimeType(), parent);
                    JCRLocalGoogleDrive.this.initFile(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                }
                this.changed.add(new JCRLocalCloudFile(localNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), JCRLocalGoogleDrive.this.editLink(gf.getAlternateLink()), gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), gf.getLastModifyingUserName(), (String)gf.getOwnerNames().get(0), created, modified, isFolder));
            }
        }
    }
}

