/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.shaded.google.api.client.auth.oauth2.TokenResponse;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import org.exoplatform.shaded.google.api.client.json.JsonFactory;

public class CloudShellCredential
extends GoogleCredential {
    private static final int ACCESS_TOKEN_INDEX = 2;
    private static final int READ_TIMEOUT_MS = 5000;
    protected static final String GET_AUTH_TOKEN_REQUEST = "2\n[]";
    private final int authPort;
    private final JsonFactory jsonFactory;

    public CloudShellCredential(int authPort, JsonFactory jsonFactory) {
        this.authPort = authPort;
        this.jsonFactory = jsonFactory;
    }

    protected int getAuthPort() {
        return this.authPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenResponse executeRefreshToken() throws IOException {
        Socket socket = new Socket("localhost", this.getAuthPort());
        socket.setSoTimeout(5000);
        TokenResponse token = new TokenResponse();
        try {
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println(GET_AUTH_TOKEN_REQUEST);
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            input.readLine();
            Collection<Object> messageArray = this.jsonFactory.createJsonParser(input).parseArray(LinkedList.class, Object.class);
            String accessToken = ((List)messageArray).get(2).toString();
            token.setAccessToken(accessToken);
        }
        finally {
            socket.close();
        }
        return token;
    }
}

