/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.auth.oauth;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.exoplatform.shaded.google.api.client.auth.oauth.OAuthParameters;
import org.exoplatform.shaded.google.api.client.auth.oauth.OAuthSigner;
import org.exoplatform.shaded.google.api.client.util.Base64;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.StringUtils;

@Beta
public final class OAuthHmacSigner
implements OAuthSigner {
    public String clientSharedSecret;
    public String tokenSharedSecret;

    public String getSignatureMethod() {
        return "HMAC-SHA1";
    }

    public String computeSignature(String signatureBaseString) throws GeneralSecurityException {
        StringBuilder keyBuf = new StringBuilder();
        String clientSharedSecret = this.clientSharedSecret;
        if (clientSharedSecret != null) {
            keyBuf.append(OAuthParameters.escape(clientSharedSecret));
        }
        keyBuf.append('&');
        String tokenSharedSecret = this.tokenSharedSecret;
        if (tokenSharedSecret != null) {
            keyBuf.append(OAuthParameters.escape(tokenSharedSecret));
        }
        String key = keyBuf.toString();
        SecretKeySpec secretKey = new SecretKeySpec(StringUtils.getBytesUtf8(key), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        return Base64.encodeBase64String(mac.doFinal(StringUtils.getBytesUtf8(signatureBaseString)));
    }
}

