/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.gdrive;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.gdrive.GoogleDriveAPI;
import org.exoplatform.clouddrive.gdrive.GoogleDriveException;
import org.exoplatform.clouddrive.gdrive.GoogleProvider;
import org.exoplatform.clouddrive.gdrive.GoogleUser;
import org.exoplatform.clouddrive.gdrive.JCRLocalGoogleDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.shaded.google.api.services.oauth2.model.Userinfoplus;

public class GoogleDriveConnector
extends CloudDriveConnector {
    public GoogleDriveConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
    }

    protected CloudProvider createProvider() {
        String redirectURL = this.redirectLink();
        StringBuilder authURL = new StringBuilder();
        authURL.append("https://accounts.google.com/o/oauth2/auth?");
        authURL.append("response_type=code&client_id=");
        String clientId = this.getClientId();
        try {
            authURL.append(URLEncoder.encode(clientId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode client id " + clientId + ":" + e));
            authURL.append(clientId);
        }
        authURL.append("&approval_prompt=");
        authURL.append("force");
        authURL.append("&scope=");
        try {
            authURL.append(URLEncoder.encode(GoogleDriveAPI.SCOPES_STRING, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode scopes " + GoogleDriveAPI.SCOPES_STRING + ":" + e));
            authURL.append(GoogleDriveAPI.SCOPES_STRING);
        }
        authURL.append("&access_type=");
        authURL.append("offline");
        authURL.append("&state=");
        try {
            authURL.append(URLEncoder.encode("__no_state_set__", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode state __no_state_set__:" + e));
            authURL.append("__no_state_set__");
        }
        authURL.append("&redirect_uri=");
        try {
            authURL.append(URLEncoder.encode(redirectURL, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Cannot encode redirect URL " + redirectURL + ":" + e));
            authURL.append(redirectURL);
        }
        return new GoogleProvider(this.getProviderId(), this.getProviderName(), authURL.toString(), redirectURL, this.jcrService);
    }

    protected GoogleProvider getProvider() {
        return (GoogleProvider)super.getProvider();
    }

    public GoogleUser authenticate(Map<String, String> params) throws CloudDriveException {
        String code = params.get("code");
        if (code != null && code.length() > 0) {
            GoogleDriveAPI driveAPI = new API().auth(code).build();
            Userinfoplus userInfo = driveAPI.userInfo();
            GoogleUser user = new GoogleUser(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access code should not be null or empty");
    }

    protected JCRLocalGoogleDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof GoogleUser) {
            return new JCRLocalGoogleDrive((GoogleUser)user, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
        }
        throw new CloudDriveException("Not Google user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        return new JCRLocalGoogleDrive(new API(), this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
    }

    class API {
        String code;
        String refreshToken;
        String accessToken;
        long expirationTime;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String userId, String refreshToken, String accessToken, long expirationTime) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        GoogleDriveAPI build() throws GoogleDriveException, CloudDriveException {
            if (this.code != null && this.code.length() > 0) {
                return new GoogleDriveAPI(GoogleDriveConnector.this.getClientId(), GoogleDriveConnector.this.getClientSecret(), this.code, GoogleDriveConnector.this.getProvider().getRedirectURL());
            }
            return new GoogleDriveAPI(GoogleDriveConnector.this.getClientId(), GoogleDriveConnector.this.getClientSecret(), this.accessToken, this.refreshToken, this.expirationTime);
        }
    }
}

